/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.ExceptionInterceptor;
import com.mysql.jdbc.Messages;
import com.mysql.jdbc.ResultSetImpl;
import com.mysql.jdbc.SQLError;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class BlobFromLocator
implements Blob {
    private List primaryKeyColumns = null;
    private List primaryKeyValues = null;
    private ResultSetImpl creatorResultSet;
    private String blobColumnName = null;
    private String tableName = null;
    private int numColsInResultSet = 0;
    private int numPrimaryKeys = 0;
    private String quotedId;
    private ExceptionInterceptor exceptionInterceptor;

    BlobFromLocator(ResultSetImpl creatorResultSetToSet, int blobColumnIndex, ExceptionInterceptor exceptionInterceptor) throws SQLException {
        this.exceptionInterceptor = exceptionInterceptor;
        this.creatorResultSet = creatorResultSetToSet;
        this.numColsInResultSet = this.creatorResultSet.fields.length;
        this.quotedId = this.creatorResultSet.connection.getMetaData().getIdentifierQuoteString();
        if (this.numColsInResultSet > 1) {
            this.primaryKeyColumns = new ArrayList();
            this.primaryKeyValues = new ArrayList();
            int i = 0;
            while (i < this.numColsInResultSet) {
                if (this.creatorResultSet.fields[i].isPrimaryKey()) {
                    StringBuffer keyName = new StringBuffer();
                    keyName.append(this.quotedId);
                    String originalColumnName = this.creatorResultSet.fields[i].getOriginalName();
                    if (originalColumnName != null && originalColumnName.length() > 0) {
                        keyName.append(originalColumnName);
                    } else {
                        keyName.append(this.creatorResultSet.fields[i].getName());
                    }
                    keyName.append(this.quotedId);
                    this.primaryKeyColumns.add(keyName.toString());
                    this.primaryKeyValues.add(this.creatorResultSet.getString(i + 1));
                }
                ++i;
            }
        } else {
            this.notEnoughInformationInQuery();
        }
        this.numPrimaryKeys = this.primaryKeyColumns.size();
        if (this.numPrimaryKeys == 0) {
            this.notEnoughInformationInQuery();
        }
        if (this.creatorResultSet.fields[0].getOriginalTableName() != null) {
            StringBuffer tableNameBuffer = new StringBuffer();
            String databaseName = this.creatorResultSet.fields[0].getDatabaseName();
            if (databaseName != null && databaseName.length() > 0) {
                tableNameBuffer.append(this.quotedId);
                tableNameBuffer.append(databaseName);
                tableNameBuffer.append(this.quotedId);
                tableNameBuffer.append('.');
            }
            tableNameBuffer.append(this.quotedId);
            tableNameBuffer.append(this.creatorResultSet.fields[0].getOriginalTableName());
            tableNameBuffer.append(this.quotedId);
            this.tableName = tableNameBuffer.toString();
        } else {
            StringBuffer tableNameBuffer = new StringBuffer();
            tableNameBuffer.append(this.quotedId);
            tableNameBuffer.append(this.creatorResultSet.fields[0].getTableName());
            tableNameBuffer.append(this.quotedId);
            this.tableName = tableNameBuffer.toString();
        }
        this.blobColumnName = String.valueOf(this.quotedId) + this.creatorResultSet.getString(blobColumnIndex) + this.quotedId;
    }

    private void notEnoughInformationInQuery() throws SQLException {
        throw SQLError.createSQLException("Emulated BLOB locators must come from a ResultSet with only one table selected, and all primary keys selected", "S1000", this.exceptionInterceptor);
    }

    public OutputStream setBinaryStream(long indexToWriteAt) throws SQLException {
        throw SQLError.notImplemented();
    }

    public InputStream getBinaryStream() throws SQLException {
        return new BufferedInputStream(new LocatorInputStream(), this.creatorResultSet.connection.getLocatorFetchBufferSize());
    }

    public int setBytes(long writeAt, byte[] bytes, int offset, int length) throws SQLException {
        PreparedStatement pStmt = null;
        if (offset + length > bytes.length) {
            length = bytes.length - offset;
        }
        byte[] bytesToWrite = new byte[length];
        System.arraycopy(bytes, offset, bytesToWrite, 0, length);
        StringBuffer query = new StringBuffer("UPDATE ");
        query.append(this.tableName);
        query.append(" SET ");
        query.append(this.blobColumnName);
        query.append(" = INSERT(");
        query.append(this.blobColumnName);
        query.append(", ");
        query.append(writeAt);
        query.append(", ");
        query.append(length);
        query.append(", ?) WHERE ");
        query.append((String)this.primaryKeyColumns.get(0));
        query.append(" = ?");
        int i = 1;
        while (i < this.numPrimaryKeys) {
            query.append(" AND ");
            query.append((String)this.primaryKeyColumns.get(i));
            query.append(" = ?");
            ++i;
        }
        try {
            pStmt = this.creatorResultSet.connection.prepareStatement(query.toString());
            pStmt.setBytes(1, bytesToWrite);
            i = 0;
            while (i < this.numPrimaryKeys) {
                pStmt.setString(i + 2, (String)this.primaryKeyValues.get(i));
                ++i;
            }
            int rowsUpdated = pStmt.executeUpdate();
            if (rowsUpdated != 1) {
                throw SQLError.createSQLException("BLOB data not found! Did primary keys change?", "S1000", this.exceptionInterceptor);
            }
        }
        catch (Throwable throwable) {
            if (pStmt != null) {
                try {
                    pStmt.close();
                }
                catch (SQLException sQLException) {}
                pStmt = null;
            }
            throw throwable;
        }
        if (pStmt != null) {
            try {
                pStmt.close();
            }
            catch (SQLException sQLException) {}
            pStmt = null;
        }
        return (int)this.length();
    }

    public int setBytes(long writeAt, byte[] bytes) throws SQLException {
        return this.setBytes(writeAt, bytes, 0, bytes.length);
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        byte[] byArray;
        block7: {
            PreparedStatement pStmt = null;
            try {
                pStmt = this.createGetBytesStatement();
                byArray = this.getBytesInternal(pStmt, pos, length);
                if (pStmt == null) break block7;
            }
            catch (Throwable throwable) {
                if (pStmt != null) {
                    try {
                        pStmt.close();
                    }
                    catch (SQLException sQLException) {}
                    pStmt = null;
                }
                throw throwable;
            }
            try {
                pStmt.close();
            }
            catch (SQLException sQLException) {}
            pStmt = null;
        }
        return byArray;
    }

    public long length() throws SQLException {
        block16: {
            long l;
            PreparedStatement pStmt;
            block17: {
                ResultSet blobRs = null;
                pStmt = null;
                StringBuffer query = new StringBuffer("SELECT LENGTH(");
                query.append(this.blobColumnName);
                query.append(") FROM ");
                query.append(this.tableName);
                query.append(" WHERE ");
                query.append((String)this.primaryKeyColumns.get(0));
                query.append(" = ?");
                int i = 1;
                while (i < this.numPrimaryKeys) {
                    query.append(" AND ");
                    query.append((String)this.primaryKeyColumns.get(i));
                    query.append(" = ?");
                    ++i;
                }
                try {
                    pStmt = this.creatorResultSet.connection.prepareStatement(query.toString());
                    i = 0;
                    while (i < this.numPrimaryKeys) {
                        pStmt.setString(i + 1, (String)this.primaryKeyValues.get(i));
                        ++i;
                    }
                    blobRs = pStmt.executeQuery();
                    if (!blobRs.next()) break block16;
                    l = blobRs.getLong(1);
                    if (blobRs == null) break block17;
                }
                catch (Throwable throwable) {
                    if (blobRs != null) {
                        try {
                            blobRs.close();
                        }
                        catch (SQLException sQLException) {}
                        blobRs = null;
                    }
                    if (pStmt != null) {
                        try {
                            pStmt.close();
                        }
                        catch (SQLException sQLException) {}
                        pStmt = null;
                    }
                    throw throwable;
                }
                try {
                    blobRs.close();
                }
                catch (SQLException sQLException) {}
                blobRs = null;
            }
            if (pStmt != null) {
                try {
                    pStmt.close();
                }
                catch (SQLException sQLException) {}
                pStmt = null;
            }
            return l;
        }
        throw SQLError.createSQLException("BLOB data not found! Did primary keys change?", "S1000", this.exceptionInterceptor);
    }

    public long position(Blob pattern, long start) throws SQLException {
        return this.position(pattern.getBytes(0L, (int)pattern.length()), start);
    }

    public long position(byte[] pattern, long start) throws SQLException {
        block16: {
            long l;
            PreparedStatement pStmt;
            block17: {
                ResultSet blobRs = null;
                pStmt = null;
                StringBuffer query = new StringBuffer("SELECT LOCATE(");
                query.append("?, ");
                query.append(this.blobColumnName);
                query.append(", ");
                query.append(start);
                query.append(") FROM ");
                query.append(this.tableName);
                query.append(" WHERE ");
                query.append((String)this.primaryKeyColumns.get(0));
                query.append(" = ?");
                int i = 1;
                while (i < this.numPrimaryKeys) {
                    query.append(" AND ");
                    query.append((String)this.primaryKeyColumns.get(i));
                    query.append(" = ?");
                    ++i;
                }
                try {
                    pStmt = this.creatorResultSet.connection.prepareStatement(query.toString());
                    pStmt.setBytes(1, pattern);
                    i = 0;
                    while (i < this.numPrimaryKeys) {
                        pStmt.setString(i + 2, (String)this.primaryKeyValues.get(i));
                        ++i;
                    }
                    blobRs = pStmt.executeQuery();
                    if (!blobRs.next()) break block16;
                    l = blobRs.getLong(1);
                    if (blobRs == null) break block17;
                }
                catch (Throwable throwable) {
                    if (blobRs != null) {
                        try {
                            blobRs.close();
                        }
                        catch (SQLException sQLException) {}
                        blobRs = null;
                    }
                    if (pStmt != null) {
                        try {
                            pStmt.close();
                        }
                        catch (SQLException sQLException) {}
                        pStmt = null;
                    }
                    throw throwable;
                }
                try {
                    blobRs.close();
                }
                catch (SQLException sQLException) {}
                blobRs = null;
            }
            if (pStmt != null) {
                try {
                    pStmt.close();
                }
                catch (SQLException sQLException) {}
                pStmt = null;
            }
            return l;
        }
        throw SQLError.createSQLException("BLOB data not found! Did primary keys change?", "S1000", this.exceptionInterceptor);
    }

    public void truncate(long length) throws SQLException {
        PreparedStatement pStmt = null;
        StringBuffer query = new StringBuffer("UPDATE ");
        query.append(this.tableName);
        query.append(" SET ");
        query.append(this.blobColumnName);
        query.append(" = LEFT(");
        query.append(this.blobColumnName);
        query.append(", ");
        query.append(length);
        query.append(") WHERE ");
        query.append((String)this.primaryKeyColumns.get(0));
        query.append(" = ?");
        int i = 1;
        while (i < this.numPrimaryKeys) {
            query.append(" AND ");
            query.append((String)this.primaryKeyColumns.get(i));
            query.append(" = ?");
            ++i;
        }
        try {
            pStmt = this.creatorResultSet.connection.prepareStatement(query.toString());
            i = 0;
            while (i < this.numPrimaryKeys) {
                pStmt.setString(i + 1, (String)this.primaryKeyValues.get(i));
                ++i;
            }
            int rowsUpdated = pStmt.executeUpdate();
            if (rowsUpdated != 1) {
                throw SQLError.createSQLException("BLOB data not found! Did primary keys change?", "S1000", this.exceptionInterceptor);
            }
        }
        catch (Throwable throwable) {
            if (pStmt != null) {
                try {
                    pStmt.close();
                }
                catch (SQLException sQLException) {}
                pStmt = null;
            }
            throw throwable;
        }
        if (pStmt != null) {
            try {
                pStmt.close();
            }
            catch (SQLException sQLException) {}
            pStmt = null;
        }
    }

    PreparedStatement createGetBytesStatement() throws SQLException {
        StringBuffer query = new StringBuffer("SELECT SUBSTRING(");
        query.append(this.blobColumnName);
        query.append(", ");
        query.append("?");
        query.append(", ");
        query.append("?");
        query.append(") FROM ");
        query.append(this.tableName);
        query.append(" WHERE ");
        query.append((String)this.primaryKeyColumns.get(0));
        query.append(" = ?");
        int i = 1;
        while (i < this.numPrimaryKeys) {
            query.append(" AND ");
            query.append((String)this.primaryKeyColumns.get(i));
            query.append(" = ?");
            ++i;
        }
        return this.creatorResultSet.connection.prepareStatement(query.toString());
    }

    byte[] getBytesInternal(PreparedStatement pStmt, long pos, int length) throws SQLException {
        block9: {
            byte[] byArray;
            block10: {
                ResultSet blobRs = null;
                try {
                    pStmt.setLong(1, pos);
                    pStmt.setInt(2, length);
                    int i = 0;
                    while (i < this.numPrimaryKeys) {
                        pStmt.setString(i + 3, (String)this.primaryKeyValues.get(i));
                        ++i;
                    }
                    blobRs = pStmt.executeQuery();
                    if (!blobRs.next()) break block9;
                    byArray = ((ResultSetImpl)blobRs).getBytes(1, true);
                    if (blobRs == null) break block10;
                }
                catch (Throwable throwable) {
                    if (blobRs != null) {
                        try {
                            blobRs.close();
                        }
                        catch (SQLException sQLException) {}
                        blobRs = null;
                    }
                    throw throwable;
                }
                try {
                    blobRs.close();
                }
                catch (SQLException sQLException) {}
                blobRs = null;
            }
            return byArray;
        }
        throw SQLError.createSQLException("BLOB data not found! Did primary keys change?", "S1000", this.exceptionInterceptor);
    }

    public void free() throws SQLException {
        this.creatorResultSet = null;
        this.primaryKeyColumns = null;
        this.primaryKeyValues = null;
    }

    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        return new LocatorInputStream(pos, length);
    }

    class LocatorInputStream
    extends InputStream {
        long currentPositionInBlob = 0L;
        long length = 0L;
        PreparedStatement pStmt = null;

        LocatorInputStream() throws SQLException {
            this.length = BlobFromLocator.this.length();
            this.pStmt = BlobFromLocator.this.createGetBytesStatement();
        }

        LocatorInputStream(long pos, long len) throws SQLException {
            this.length = pos + len;
            this.currentPositionInBlob = pos;
            long blobLength = BlobFromLocator.this.length();
            if (pos + len > blobLength) {
                throw SQLError.createSQLException(Messages.getString("Blob.invalidStreamLength", new Object[]{blobLength, pos, len}), "S1009", BlobFromLocator.this.exceptionInterceptor);
            }
            if (pos < 1L) {
                throw SQLError.createSQLException(Messages.getString("Blob.invalidStreamPos"), "S1009", BlobFromLocator.this.exceptionInterceptor);
            }
            if (pos > blobLength) {
                throw SQLError.createSQLException(Messages.getString("Blob.invalidStreamPos"), "S1009", BlobFromLocator.this.exceptionInterceptor);
            }
        }

        public int read() throws IOException {
            byte[] asBytes;
            block4: {
                if (this.currentPositionInBlob + 1L > this.length) {
                    return -1;
                }
                try {
                    asBytes = BlobFromLocator.this.getBytesInternal(this.pStmt, this.currentPositionInBlob++ + 1L, 1);
                    if (asBytes != null) break block4;
                    return -1;
                }
                catch (SQLException sqlEx) {
                    throw new IOException(sqlEx.toString());
                }
            }
            return asBytes[0];
        }

        public int read(byte[] b, int off, int len) throws IOException {
            byte[] asBytes;
            block4: {
                if (this.currentPositionInBlob + 1L > this.length) {
                    return -1;
                }
                try {
                    asBytes = BlobFromLocator.this.getBytesInternal(this.pStmt, this.currentPositionInBlob + 1L, len);
                    if (asBytes != null) break block4;
                    return -1;
                }
                catch (SQLException sqlEx) {
                    throw new IOException(sqlEx.toString());
                }
            }
            System.arraycopy(asBytes, 0, b, off, asBytes.length);
            this.currentPositionInBlob += (long)asBytes.length;
            return asBytes.length;
        }

        public int read(byte[] b) throws IOException {
            byte[] asBytes;
            block4: {
                if (this.currentPositionInBlob + 1L > this.length) {
                    return -1;
                }
                try {
                    asBytes = BlobFromLocator.this.getBytesInternal(this.pStmt, this.currentPositionInBlob + 1L, b.length);
                    if (asBytes != null) break block4;
                    return -1;
                }
                catch (SQLException sqlEx) {
                    throw new IOException(sqlEx.toString());
                }
            }
            System.arraycopy(asBytes, 0, b, 0, asBytes.length);
            this.currentPositionInBlob += (long)asBytes.length;
            return asBytes.length;
        }

        public void close() throws IOException {
            if (this.pStmt != null) {
                try {
                    this.pStmt.close();
                }
                catch (SQLException sqlEx) {
                    throw new IOException(sqlEx.toString());
                }
            }
            super.close();
        }
    }
}

