/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.CommunicationsException;
import com.mysql.jdbc.Connection;
import com.mysql.jdbc.ExceptionInterceptor;
import com.mysql.jdbc.Messages;
import com.mysql.jdbc.MySQLConnection;
import com.mysql.jdbc.MysqlDataTruncation;
import com.mysql.jdbc.MysqlErrorNumbers;
import com.mysql.jdbc.NotImplemented;
import com.mysql.jdbc.Util;
import com.mysql.jdbc.exceptions.MySQLDataException;
import com.mysql.jdbc.exceptions.MySQLIntegrityConstraintViolationException;
import com.mysql.jdbc.exceptions.MySQLNonTransientConnectionException;
import com.mysql.jdbc.exceptions.MySQLSyntaxErrorException;
import com.mysql.jdbc.exceptions.MySQLTransactionRollbackException;
import com.mysql.jdbc.exceptions.MySQLTransientConnectionException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.BindException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;

public class SQLError {
    static final int ER_WARNING_NOT_COMPLETE_ROLLBACK = 1196;
    private static Map mysqlToSql99State;
    private static Map mysqlToSqlState;
    public static final String SQL_STATE_BASE_TABLE_NOT_FOUND = "S0002";
    public static final String SQL_STATE_BASE_TABLE_OR_VIEW_ALREADY_EXISTS = "S0001";
    public static final String SQL_STATE_BASE_TABLE_OR_VIEW_NOT_FOUND = "42S02";
    public static final String SQL_STATE_COLUMN_ALREADY_EXISTS = "S0021";
    public static final String SQL_STATE_COLUMN_NOT_FOUND = "S0022";
    public static final String SQL_STATE_COMMUNICATION_LINK_FAILURE = "08S01";
    public static final String SQL_STATE_CONNECTION_FAIL_DURING_TX = "08007";
    public static final String SQL_STATE_CONNECTION_IN_USE = "08002";
    public static final String SQL_STATE_CONNECTION_NOT_OPEN = "08003";
    public static final String SQL_STATE_CONNECTION_REJECTED = "08004";
    public static final String SQL_STATE_DATE_TRUNCATED = "01004";
    public static final String SQL_STATE_DATETIME_FIELD_OVERFLOW = "22008";
    public static final String SQL_STATE_DEADLOCK = "41000";
    public static final String SQL_STATE_DISCONNECT_ERROR = "01002";
    public static final String SQL_STATE_DIVISION_BY_ZERO = "22012";
    public static final String SQL_STATE_DRIVER_NOT_CAPABLE = "S1C00";
    public static final String SQL_STATE_ERROR_IN_ROW = "01S01";
    public static final String SQL_STATE_GENERAL_ERROR = "S1000";
    public static final String SQL_STATE_ILLEGAL_ARGUMENT = "S1009";
    public static final String SQL_STATE_INDEX_ALREADY_EXISTS = "S0011";
    public static final String SQL_STATE_INDEX_NOT_FOUND = "S0012";
    public static final String SQL_STATE_INSERT_VALUE_LIST_NO_MATCH_COL_LIST = "21S01";
    public static final String SQL_STATE_INVALID_AUTH_SPEC = "28000";
    public static final String SQL_STATE_INVALID_CHARACTER_VALUE_FOR_CAST = "22018";
    public static final String SQL_STATE_INVALID_COLUMN_NUMBER = "S1002";
    public static final String SQL_STATE_INVALID_CONNECTION_ATTRIBUTE = "01S00";
    public static final String SQL_STATE_MEMORY_ALLOCATION_FAILURE = "S1001";
    public static final String SQL_STATE_MORE_THAN_ONE_ROW_UPDATED_OR_DELETED = "01S04";
    public static final String SQL_STATE_NO_DEFAULT_FOR_COLUMN = "S0023";
    public static final String SQL_STATE_NO_ROWS_UPDATED_OR_DELETED = "01S03";
    public static final String SQL_STATE_NUMERIC_VALUE_OUT_OF_RANGE = "22003";
    public static final String SQL_STATE_PRIVILEGE_NOT_REVOKED = "01006";
    public static final String SQL_STATE_SYNTAX_ERROR = "42000";
    public static final String SQL_STATE_TIMEOUT_EXPIRED = "S1T00";
    public static final String SQL_STATE_TRANSACTION_RESOLUTION_UNKNOWN = "08007";
    public static final String SQL_STATE_UNABLE_TO_CONNECT_TO_DATASOURCE = "08001";
    public static final String SQL_STATE_WRONG_NO_OF_PARAMETERS = "07001";
    public static final String SQL_STATE_INVALID_TRANSACTION_TERMINATION = "2D000";
    private static Map sqlStateMessages;
    private static final long DEFAULT_WAIT_TIMEOUT_SECONDS = 28800L;
    private static final int DUE_TO_TIMEOUT_FALSE = 0;
    private static final int DUE_TO_TIMEOUT_MAYBE = 2;
    private static final int DUE_TO_TIMEOUT_TRUE = 1;
    private static final Constructor JDBC_4_COMMUNICATIONS_EXCEPTION_CTOR;
    private static Method THROWABLE_INIT_CAUSE_METHOD;

    static {
        if (Util.isJdbc4()) {
            try {
                JDBC_4_COMMUNICATIONS_EXCEPTION_CTOR = Class.forName("com.mysql.jdbc.exceptions.jdbc4.CommunicationsException").getConstructor(MySQLConnection.class, Long.TYPE, Long.TYPE, Exception.class);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        } else {
            JDBC_4_COMMUNICATIONS_EXCEPTION_CTOR = null;
        }
        try {
            THROWABLE_INIT_CAUSE_METHOD = Throwable.class.getMethod("initCause", Throwable.class);
        }
        catch (Throwable throwable) {
            THROWABLE_INIT_CAUSE_METHOD = null;
        }
        sqlStateMessages = new HashMap();
        sqlStateMessages.put(SQL_STATE_DISCONNECT_ERROR, Messages.getString("SQLError.35"));
        sqlStateMessages.put(SQL_STATE_DATE_TRUNCATED, Messages.getString("SQLError.36"));
        sqlStateMessages.put(SQL_STATE_PRIVILEGE_NOT_REVOKED, Messages.getString("SQLError.37"));
        sqlStateMessages.put(SQL_STATE_INVALID_CONNECTION_ATTRIBUTE, Messages.getString("SQLError.38"));
        sqlStateMessages.put(SQL_STATE_ERROR_IN_ROW, Messages.getString("SQLError.39"));
        sqlStateMessages.put(SQL_STATE_NO_ROWS_UPDATED_OR_DELETED, Messages.getString("SQLError.40"));
        sqlStateMessages.put(SQL_STATE_MORE_THAN_ONE_ROW_UPDATED_OR_DELETED, Messages.getString("SQLError.41"));
        sqlStateMessages.put(SQL_STATE_WRONG_NO_OF_PARAMETERS, Messages.getString("SQLError.42"));
        sqlStateMessages.put(SQL_STATE_UNABLE_TO_CONNECT_TO_DATASOURCE, Messages.getString("SQLError.43"));
        sqlStateMessages.put(SQL_STATE_CONNECTION_IN_USE, Messages.getString("SQLError.44"));
        sqlStateMessages.put(SQL_STATE_CONNECTION_NOT_OPEN, Messages.getString("SQLError.45"));
        sqlStateMessages.put(SQL_STATE_CONNECTION_REJECTED, Messages.getString("SQLError.46"));
        sqlStateMessages.put("08007", Messages.getString("SQLError.47"));
        sqlStateMessages.put(SQL_STATE_COMMUNICATION_LINK_FAILURE, Messages.getString("SQLError.48"));
        sqlStateMessages.put(SQL_STATE_INSERT_VALUE_LIST_NO_MATCH_COL_LIST, Messages.getString("SQLError.49"));
        sqlStateMessages.put(SQL_STATE_NUMERIC_VALUE_OUT_OF_RANGE, Messages.getString("SQLError.50"));
        sqlStateMessages.put(SQL_STATE_DATETIME_FIELD_OVERFLOW, Messages.getString("SQLError.51"));
        sqlStateMessages.put(SQL_STATE_DIVISION_BY_ZERO, Messages.getString("SQLError.52"));
        sqlStateMessages.put(SQL_STATE_DEADLOCK, Messages.getString("SQLError.53"));
        sqlStateMessages.put(SQL_STATE_INVALID_AUTH_SPEC, Messages.getString("SQLError.54"));
        sqlStateMessages.put(SQL_STATE_SYNTAX_ERROR, Messages.getString("SQLError.55"));
        sqlStateMessages.put(SQL_STATE_BASE_TABLE_OR_VIEW_NOT_FOUND, Messages.getString("SQLError.56"));
        sqlStateMessages.put(SQL_STATE_BASE_TABLE_OR_VIEW_ALREADY_EXISTS, Messages.getString("SQLError.57"));
        sqlStateMessages.put(SQL_STATE_BASE_TABLE_NOT_FOUND, Messages.getString("SQLError.58"));
        sqlStateMessages.put(SQL_STATE_INDEX_ALREADY_EXISTS, Messages.getString("SQLError.59"));
        sqlStateMessages.put(SQL_STATE_INDEX_NOT_FOUND, Messages.getString("SQLError.60"));
        sqlStateMessages.put(SQL_STATE_COLUMN_ALREADY_EXISTS, Messages.getString("SQLError.61"));
        sqlStateMessages.put(SQL_STATE_COLUMN_NOT_FOUND, Messages.getString("SQLError.62"));
        sqlStateMessages.put(SQL_STATE_NO_DEFAULT_FOR_COLUMN, Messages.getString("SQLError.63"));
        sqlStateMessages.put(SQL_STATE_GENERAL_ERROR, Messages.getString("SQLError.64"));
        sqlStateMessages.put(SQL_STATE_MEMORY_ALLOCATION_FAILURE, Messages.getString("SQLError.65"));
        sqlStateMessages.put(SQL_STATE_INVALID_COLUMN_NUMBER, Messages.getString("SQLError.66"));
        sqlStateMessages.put(SQL_STATE_ILLEGAL_ARGUMENT, Messages.getString("SQLError.67"));
        sqlStateMessages.put(SQL_STATE_DRIVER_NOT_CAPABLE, Messages.getString("SQLError.68"));
        sqlStateMessages.put(SQL_STATE_TIMEOUT_EXPIRED, Messages.getString("SQLError.69"));
        mysqlToSqlState = new Hashtable();
        mysqlToSqlState.put(1040, SQL_STATE_CONNECTION_REJECTED);
        mysqlToSqlState.put(1042, SQL_STATE_CONNECTION_REJECTED);
        mysqlToSqlState.put(1043, SQL_STATE_CONNECTION_REJECTED);
        mysqlToSqlState.put(1047, SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSqlState.put(1081, SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSqlState.put(1129, SQL_STATE_CONNECTION_REJECTED);
        mysqlToSqlState.put(1130, SQL_STATE_CONNECTION_REJECTED);
        mysqlToSqlState.put(1045, SQL_STATE_INVALID_AUTH_SPEC);
        mysqlToSqlState.put(1037, SQL_STATE_MEMORY_ALLOCATION_FAILURE);
        mysqlToSqlState.put(1038, SQL_STATE_MEMORY_ALLOCATION_FAILURE);
        mysqlToSqlState.put(1064, SQL_STATE_SYNTAX_ERROR);
        mysqlToSqlState.put(1065, SQL_STATE_SYNTAX_ERROR);
        mysqlToSqlState.put(1055, SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(1056, SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(1057, SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(1059, SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(1060, SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(1061, SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(1062, SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(1063, SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(1066, SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(1067, SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(1068, SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(1069, SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(1070, SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(1071, SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(1072, SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(1073, SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(1074, SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(1075, SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(1082, SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(1083, SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(1084, SQL_STATE_ILLEGAL_ARGUMENT);
        mysqlToSqlState.put(1058, SQL_STATE_INSERT_VALUE_LIST_NO_MATCH_COL_LIST);
        mysqlToSqlState.put(1051, SQL_STATE_BASE_TABLE_OR_VIEW_NOT_FOUND);
        mysqlToSqlState.put(1054, SQL_STATE_COLUMN_NOT_FOUND);
        mysqlToSqlState.put(1205, SQL_STATE_DEADLOCK);
        mysqlToSqlState.put(1213, SQL_STATE_DEADLOCK);
        mysqlToSql99State = new HashMap();
        mysqlToSql99State.put(1205, SQL_STATE_DEADLOCK);
        mysqlToSql99State.put(1213, SQL_STATE_DEADLOCK);
        mysqlToSql99State.put(1022, "23000");
        mysqlToSql99State.put(1037, "HY001");
        mysqlToSql99State.put(1038, "HY001");
        mysqlToSql99State.put(1040, SQL_STATE_CONNECTION_REJECTED);
        mysqlToSql99State.put(1042, SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(1043, SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(1044, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1045, SQL_STATE_INVALID_AUTH_SPEC);
        mysqlToSql99State.put(1050, "42S01");
        mysqlToSql99State.put(1051, SQL_STATE_BASE_TABLE_OR_VIEW_NOT_FOUND);
        mysqlToSql99State.put(1052, "23000");
        mysqlToSql99State.put(1053, SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(1054, "42S22");
        mysqlToSql99State.put(1055, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1056, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1057, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1058, SQL_STATE_INSERT_VALUE_LIST_NO_MATCH_COL_LIST);
        mysqlToSql99State.put(1059, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1060, "42S21");
        mysqlToSql99State.put(1061, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1062, "23000");
        mysqlToSql99State.put(1063, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1064, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1065, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1066, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1067, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1068, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1069, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1070, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1071, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1072, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1073, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1074, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1075, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1080, SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(1081, SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(1082, "42S12");
        mysqlToSql99State.put(1083, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1084, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1090, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1091, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1101, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1102, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1103, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1104, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1106, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1107, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1109, SQL_STATE_BASE_TABLE_OR_VIEW_NOT_FOUND);
        mysqlToSql99State.put(1110, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1112, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1113, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1115, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1118, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1120, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1121, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1131, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1132, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1133, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1136, SQL_STATE_INSERT_VALUE_LIST_NO_MATCH_COL_LIST);
        mysqlToSql99State.put(1138, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1139, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1140, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1141, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1142, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1143, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1144, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1145, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1146, SQL_STATE_BASE_TABLE_OR_VIEW_NOT_FOUND);
        mysqlToSql99State.put(1147, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1148, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1149, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1152, SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(1153, SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(1154, SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(1155, SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(1156, SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(1157, SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(1158, SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(1159, SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(1160, SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(1161, SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(1162, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1163, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1164, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1166, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1167, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1169, "23000");
        mysqlToSql99State.put(1170, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1171, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1172, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1173, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1177, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1178, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1179, "25000");
        mysqlToSql99State.put(1184, SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(1189, SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(1190, SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(1203, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1207, "25000");
        mysqlToSql99State.put(1211, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1213, "40001");
        mysqlToSql99State.put(1216, "23000");
        mysqlToSql99State.put(1217, "23000");
        mysqlToSql99State.put(1218, SQL_STATE_COMMUNICATION_LINK_FAILURE);
        mysqlToSql99State.put(1222, "21000");
        mysqlToSql99State.put(1226, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1230, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1231, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1232, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1234, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1235, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1239, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1241, "21000");
        mysqlToSql99State.put(1242, "21000");
        mysqlToSql99State.put(1247, "42S22");
        mysqlToSql99State.put(1248, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1249, "01000");
        mysqlToSql99State.put(1250, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1251, SQL_STATE_CONNECTION_REJECTED);
        mysqlToSql99State.put(1252, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1253, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1261, "01000");
        mysqlToSql99State.put(1262, "01000");
        mysqlToSql99State.put(1263, "01000");
        mysqlToSql99State.put(1264, "01000");
        mysqlToSql99State.put(1265, "01000");
        mysqlToSql99State.put(1280, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1281, SQL_STATE_SYNTAX_ERROR);
        mysqlToSql99State.put(1286, SQL_STATE_SYNTAX_ERROR);
    }

    static SQLWarning convertShowWarningsToSQLWarnings(Connection connection) throws SQLException {
        return SQLError.convertShowWarningsToSQLWarnings(connection, 0, false);
    }

    static SQLWarning convertShowWarningsToSQLWarnings(Connection connection, int warningCountIfKnown, boolean forTruncationOnly) throws SQLException {
        Statement stmt = null;
        ResultSet warnRs = null;
        SQLWarning currentWarning = null;
        try {
            if (warningCountIfKnown < 100) {
                stmt = connection.createStatement();
                if (stmt.getMaxRows() != 0) {
                    stmt.setMaxRows(0);
                }
            } else {
                stmt = connection.createStatement(1003, 1007);
                stmt.setFetchSize(Integer.MIN_VALUE);
            }
            warnRs = stmt.executeQuery("SHOW WARNINGS");
            while (warnRs.next()) {
                int code = warnRs.getInt("Code");
                if (forTruncationOnly) {
                    if (code != 1265 && code != 1264) continue;
                    MysqlDataTruncation newTruncation = new MysqlDataTruncation(warnRs.getString("Message"), 0, false, false, 0, 0, code);
                    if (currentWarning == null) {
                        currentWarning = newTruncation;
                        continue;
                    }
                    currentWarning.setNextWarning(newTruncation);
                    continue;
                }
                warnRs.getString("Level");
                String message = warnRs.getString("Message");
                SQLWarning newWarning = new SQLWarning(message, SQLError.mysqlToSqlState(code, connection.getUseSqlStateCodes()), code);
                if (currentWarning == null) {
                    currentWarning = newWarning;
                    continue;
                }
                currentWarning.setNextWarning(newWarning);
            }
            if (forTruncationOnly && currentWarning != null) {
                throw currentWarning;
            }
            MysqlDataTruncation mysqlDataTruncation = currentWarning;
            return mysqlDataTruncation;
        }
        finally {
            SQLException reThrow = null;
            if (warnRs != null) {
                try {
                    warnRs.close();
                }
                catch (SQLException sqlEx) {
                    reThrow = sqlEx;
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sqlEx) {
                    reThrow = sqlEx;
                }
            }
            if (reThrow != null) {
                throw reThrow;
            }
        }
    }

    public static void dumpSqlStatesMappingsAsXml() throws Exception {
        TreeMap<Integer, Integer> allErrorNumbers = new TreeMap<Integer, Integer>();
        HashMap<Object, String> mysqlErrorNumbersToNames = new HashMap<Object, String>();
        Integer errorNumber2 = null;
        for (Integer errorNumber2 : mysqlToSql99State.keySet()) {
            allErrorNumbers.put(errorNumber2, errorNumber2);
        }
        for (Integer errorNumber2 : mysqlToSqlState.keySet()) {
            allErrorNumbers.put(errorNumber2, errorNumber2);
        }
        Field[] possibleFields = MysqlErrorNumbers.class.getDeclaredFields();
        int i = 0;
        while (i < possibleFields.length) {
            String fieldName = possibleFields[i].getName();
            if (fieldName.startsWith("ER_")) {
                mysqlErrorNumbersToNames.put(possibleFields[i].get(null), fieldName);
            }
            ++i;
        }
        System.out.println("<ErrorMappings>");
        for (Integer errorNumber2 : allErrorNumbers.keySet()) {
            String sql92State = SQLError.mysqlToSql99(errorNumber2);
            String oldSqlState = SQLError.mysqlToXOpen(errorNumber2);
            System.out.println("   <ErrorMapping mysqlErrorNumber=\"" + errorNumber2 + "\" mysqlErrorName=\"" + mysqlErrorNumbersToNames.get(errorNumber2) + "\" legacySqlState=\"" + (oldSqlState == null ? "" : oldSqlState) + "\" sql92SqlState=\"" + (sql92State == null ? "" : sql92State) + "\"/>");
        }
        System.out.println("</ErrorMappings>");
    }

    static String get(String stateCode) {
        return (String)sqlStateMessages.get(stateCode);
    }

    private static String mysqlToSql99(int errno) {
        Integer err = errno;
        if (mysqlToSql99State.containsKey(err)) {
            return (String)mysqlToSql99State.get(err);
        }
        return "HY000";
    }

    static String mysqlToSqlState(int errno, boolean useSql92States) {
        if (useSql92States) {
            return SQLError.mysqlToSql99(errno);
        }
        return SQLError.mysqlToXOpen(errno);
    }

    private static String mysqlToXOpen(int errno) {
        Integer err = errno;
        if (mysqlToSqlState.containsKey(err)) {
            return (String)mysqlToSqlState.get(err);
        }
        return SQL_STATE_GENERAL_ERROR;
    }

    public static SQLException createSQLException(String message, String sqlState, ExceptionInterceptor interceptor) {
        return SQLError.createSQLException(message, sqlState, 0, interceptor);
    }

    public static SQLException createSQLException(String message, ExceptionInterceptor interceptor) {
        return SQLError.createSQLException(message, interceptor, null);
    }

    public static SQLException createSQLException(String message, ExceptionInterceptor interceptor, Connection conn) {
        SQLException interceptedEx;
        SQLException sqlEx = new SQLException(message);
        if (interceptor != null && (interceptedEx = interceptor.interceptException(sqlEx, conn)) != null) {
            return interceptedEx;
        }
        return sqlEx;
    }

    public static SQLException createSQLException(String message, String sqlState, Throwable cause, ExceptionInterceptor interceptor) {
        return SQLError.createSQLException(message, sqlState, cause, interceptor, null);
    }

    public static SQLException createSQLException(String message, String sqlState, Throwable cause, ExceptionInterceptor interceptor, Connection conn) {
        SQLException interceptedEx;
        if (THROWABLE_INIT_CAUSE_METHOD == null && cause != null) {
            message = String.valueOf(message) + " due to " + cause.toString();
        }
        SQLException sqlEx = SQLError.createSQLException(message, sqlState, interceptor);
        if (cause != null && THROWABLE_INIT_CAUSE_METHOD != null) {
            try {
                THROWABLE_INIT_CAUSE_METHOD.invoke((Object)sqlEx, cause);
            }
            catch (Throwable throwable) {}
        }
        if (interceptor != null && (interceptedEx = interceptor.interceptException(sqlEx, conn)) != null) {
            return interceptedEx;
        }
        return sqlEx;
    }

    public static SQLException createSQLException(String message, String sqlState, int vendorErrorCode, ExceptionInterceptor interceptor) {
        return SQLError.createSQLException(message, sqlState, vendorErrorCode, false, interceptor);
    }

    public static SQLException createSQLException(String message, String sqlState, int vendorErrorCode, boolean isTransient, ExceptionInterceptor interceptor) {
        return SQLError.createSQLException(message, sqlState, vendorErrorCode, false, interceptor, null);
    }

    public static SQLException createSQLException(String message, String sqlState, int vendorErrorCode, boolean isTransient, ExceptionInterceptor interceptor, Connection conn) {
        try {
            SQLException interceptedEx;
            SQLException sqlEx = null;
            sqlEx = sqlState != null ? (sqlState.startsWith("08") ? (isTransient ? (!Util.isJdbc4() ? new MySQLTransientConnectionException(message, sqlState, vendorErrorCode) : (SQLException)Util.getInstance("com.mysql.jdbc.exceptions.jdbc4.MySQLTransientConnectionException", new Class[]{String.class, String.class, Integer.TYPE}, new Object[]{message, sqlState, vendorErrorCode}, interceptor)) : (!Util.isJdbc4() ? new MySQLNonTransientConnectionException(message, sqlState, vendorErrorCode) : (SQLException)Util.getInstance("com.mysql.jdbc.exceptions.jdbc4.MySQLNonTransientConnectionException", new Class[]{String.class, String.class, Integer.TYPE}, new Object[]{message, sqlState, vendorErrorCode}, interceptor))) : (sqlState.startsWith("22") ? (!Util.isJdbc4() ? new MySQLDataException(message, sqlState, vendorErrorCode) : (SQLException)Util.getInstance("com.mysql.jdbc.exceptions.jdbc4.MySQLDataException", new Class[]{String.class, String.class, Integer.TYPE}, new Object[]{message, sqlState, vendorErrorCode}, interceptor)) : (sqlState.startsWith("23") ? (!Util.isJdbc4() ? new MySQLIntegrityConstraintViolationException(message, sqlState, vendorErrorCode) : (SQLException)Util.getInstance("com.mysql.jdbc.exceptions.jdbc4.MySQLIntegrityConstraintViolationException", new Class[]{String.class, String.class, Integer.TYPE}, new Object[]{message, sqlState, vendorErrorCode}, interceptor)) : (sqlState.startsWith("42") ? (!Util.isJdbc4() ? new MySQLSyntaxErrorException(message, sqlState, vendorErrorCode) : (SQLException)Util.getInstance("com.mysql.jdbc.exceptions.jdbc4.MySQLSyntaxErrorException", new Class[]{String.class, String.class, Integer.TYPE}, new Object[]{message, sqlState, vendorErrorCode}, interceptor)) : (sqlState.startsWith("40") ? (!Util.isJdbc4() ? new MySQLTransactionRollbackException(message, sqlState, vendorErrorCode) : (SQLException)Util.getInstance("com.mysql.jdbc.exceptions.jdbc4.MySQLTransactionRollbackException", new Class[]{String.class, String.class, Integer.TYPE}, new Object[]{message, sqlState, vendorErrorCode}, interceptor)) : new SQLException(message, sqlState, vendorErrorCode)))))) : new SQLException(message, sqlState, vendorErrorCode);
            if (interceptor != null && (interceptedEx = interceptor.interceptException(sqlEx, conn)) != null) {
                return interceptedEx;
            }
            return sqlEx;
        }
        catch (SQLException sqlEx) {
            SQLException interceptedEx;
            SQLException unexpectedEx = new SQLException("Unable to create correct SQLException class instance, error class/codes may be incorrect. Reason: " + Util.stackTraceToString(sqlEx), SQL_STATE_GENERAL_ERROR);
            if (interceptor != null && (interceptedEx = interceptor.interceptException(unexpectedEx, conn)) != null) {
                return interceptedEx;
            }
            return unexpectedEx;
        }
    }

    public static SQLException createCommunicationsException(MySQLConnection conn, long lastPacketSentTimeMs, long lastPacketReceivedTimeMs, Exception underlyingException, ExceptionInterceptor interceptor) {
        SQLException interceptedEx;
        SQLException exToReturn = null;
        if (!Util.isJdbc4()) {
            exToReturn = new CommunicationsException(conn, lastPacketSentTimeMs, lastPacketReceivedTimeMs, underlyingException);
        } else {
            try {
                exToReturn = (SQLException)Util.handleNewInstance(JDBC_4_COMMUNICATIONS_EXCEPTION_CTOR, new Object[]{conn, lastPacketSentTimeMs, lastPacketReceivedTimeMs, underlyingException}, interceptor);
            }
            catch (SQLException sqlEx) {
                return sqlEx;
            }
        }
        if (THROWABLE_INIT_CAUSE_METHOD != null && underlyingException != null) {
            try {
                THROWABLE_INIT_CAUSE_METHOD.invoke((Object)exToReturn, underlyingException);
            }
            catch (Throwable throwable) {}
        }
        if (interceptor != null && (interceptedEx = interceptor.interceptException(exToReturn, conn)) != null) {
            return interceptedEx;
        }
        return exToReturn;
    }

    public static String createLinkFailureMessageBasedOnHeuristics(MySQLConnection conn, long lastPacketSentTimeMs, long lastPacketReceivedTimeMs, Exception underlyingException, boolean streamingResultSetInPlay) {
        Object[] timingInfo;
        long serverTimeoutSeconds = 0L;
        boolean isInteractiveClient = false;
        if (conn != null) {
            isInteractiveClient = conn.getInteractiveClient();
            String serverTimeoutSecondsStr = null;
            serverTimeoutSecondsStr = isInteractiveClient ? conn.getServerVariable("interactive_timeout") : conn.getServerVariable("wait_timeout");
            if (serverTimeoutSecondsStr != null) {
                try {
                    serverTimeoutSeconds = Long.parseLong(serverTimeoutSecondsStr);
                }
                catch (NumberFormatException numberFormatException) {
                    serverTimeoutSeconds = 0L;
                }
            }
        }
        StringBuffer exceptionMessageBuf = new StringBuffer();
        if (lastPacketSentTimeMs == 0L) {
            lastPacketSentTimeMs = System.currentTimeMillis();
        }
        long timeSinceLastPacket = (System.currentTimeMillis() - lastPacketSentTimeMs) / 1000L;
        long timeSinceLastPacketMs = System.currentTimeMillis() - lastPacketSentTimeMs;
        long timeSinceLastPacketReceivedMs = System.currentTimeMillis() - lastPacketReceivedTimeMs;
        int dueToTimeout = 0;
        StringBuffer timeoutMessageBuf = null;
        if (streamingResultSetInPlay) {
            exceptionMessageBuf.append(Messages.getString("CommunicationsException.ClientWasStreaming"));
        } else {
            if (serverTimeoutSeconds != 0L) {
                if (timeSinceLastPacket > serverTimeoutSeconds) {
                    dueToTimeout = 1;
                    timeoutMessageBuf = new StringBuffer();
                    timeoutMessageBuf.append(Messages.getString("CommunicationsException.2"));
                    if (!isInteractiveClient) {
                        timeoutMessageBuf.append(Messages.getString("CommunicationsException.3"));
                    } else {
                        timeoutMessageBuf.append(Messages.getString("CommunicationsException.4"));
                    }
                }
            } else if (timeSinceLastPacket > 28800L) {
                dueToTimeout = 2;
                timeoutMessageBuf = new StringBuffer();
                timeoutMessageBuf.append(Messages.getString("CommunicationsException.5"));
                timeoutMessageBuf.append(Messages.getString("CommunicationsException.6"));
                timeoutMessageBuf.append(Messages.getString("CommunicationsException.7"));
                timeoutMessageBuf.append(Messages.getString("CommunicationsException.8"));
            }
            if (dueToTimeout == 1 || dueToTimeout == 2) {
                if (lastPacketReceivedTimeMs != 0L) {
                    timingInfo = new Object[]{timeSinceLastPacketReceivedMs, timeSinceLastPacketMs};
                    exceptionMessageBuf.append(Messages.getString("CommunicationsException.ServerPacketTimingInfo", timingInfo));
                } else {
                    exceptionMessageBuf.append(Messages.getString("CommunicationsException.ServerPacketTimingInfoNoRecv", new Object[]{timeSinceLastPacketMs}));
                }
                if (timeoutMessageBuf != null) {
                    exceptionMessageBuf.append(timeoutMessageBuf);
                }
                exceptionMessageBuf.append(Messages.getString("CommunicationsException.11"));
                exceptionMessageBuf.append(Messages.getString("CommunicationsException.12"));
                exceptionMessageBuf.append(Messages.getString("CommunicationsException.13"));
            } else if (underlyingException instanceof BindException) {
                if (conn.getLocalSocketAddress() != null && !Util.interfaceExists(conn.getLocalSocketAddress())) {
                    exceptionMessageBuf.append(Messages.getString("CommunicationsException.LocalSocketAddressNotAvailable"));
                } else {
                    exceptionMessageBuf.append(Messages.getString("CommunicationsException.TooManyClientConnections"));
                }
            }
        }
        if (exceptionMessageBuf.length() == 0) {
            exceptionMessageBuf.append(Messages.getString("CommunicationsException.20"));
            if (THROWABLE_INIT_CAUSE_METHOD == null && underlyingException != null) {
                exceptionMessageBuf.append(Messages.getString("CommunicationsException.21"));
                exceptionMessageBuf.append(Util.stackTraceToString(underlyingException));
            }
            if (conn != null && conn.getMaintainTimeStats() && !conn.getParanoid()) {
                exceptionMessageBuf.append("\n\n");
                if (lastPacketReceivedTimeMs != 0L) {
                    timingInfo = new Object[]{timeSinceLastPacketReceivedMs, timeSinceLastPacketMs};
                    exceptionMessageBuf.append(Messages.getString("CommunicationsException.ServerPacketTimingInfo", timingInfo));
                } else {
                    exceptionMessageBuf.append(Messages.getString("CommunicationsException.ServerPacketTimingInfoNoRecv", new Object[]{timeSinceLastPacketMs}));
                }
            }
        }
        return exceptionMessageBuf.toString();
    }

    public static SQLException notImplemented() {
        if (Util.isJdbc4()) {
            try {
                return (SQLException)Class.forName("java.sql.SQLFeatureNotSupportedException").newInstance();
            }
            catch (Throwable throwable) {}
        }
        return new NotImplemented();
    }
}

