/*
 * Decompiled with CFR 0.152.
 */
package sqlline;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.text.ChoiceFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jline.ArgumentCompletor;
import jline.ClassNameCompletor;
import jline.Completor;
import jline.ConsoleReader;
import jline.FileNameCompletor;
import jline.MultiCompletor;
import jline.NullCompletor;
import jline.SimpleCompletor;
import jline.Terminal;

public class SqlLine {
    private static final ResourceBundle loc = ResourceBundle.getBundle((class$sqlline$SqlLine == null ? (class$sqlline$SqlLine = SqlLine.class$("sqlline.SqlLine")) : class$sqlline$SqlLine).getName());
    private static final String sep = System.getProperty("line.separator");
    private boolean exit = false;
    private final SqlLine sqlline = this;
    private Collection drivers = null;
    private Connections connections = new Connections();
    public static final String COMMAND_PREFIX = "!";
    private Completor sqlLineCommandCompletor;
    private Map completions = new HashMap();
    private Opts opts = new Opts(System.getProperties());
    String lastProgress = null;
    String prompt = "sqlline";
    private Map seenWarnings = new HashMap();
    private final Commands command = new Commands();
    private OutputFile script = null;
    private OutputFile record = null;
    private ConsoleReader reader;
    private List batch = null;
    private final Map formats = SqlLine.map(new Object[]{"vertical", new VerticalOutputFormat(), "table", new TableOutputFormat(), "csv", new SeparatedValuesOutputFormat(','), "tsv", new SeparatedValuesOutputFormat('\t'), "xmlattr", new XMLAttributeOutputFormat(), "xmlelements", new XMLElementOutputFormat()});
    private CommandHandler[] commands = new CommandHandler[]{new ReflectiveCommandHandler(new String[]{"quit", "done", "exit"}, null), new ReflectiveCommandHandler(new String[]{"connect", "open"}, new Completor[]{new SimpleCompletor(this.getConnectionURLExamples())}), new ReflectiveCommandHandler(new String[]{"describe"}, new Completor[]{new TableNameCompletor()}), new ReflectiveCommandHandler(new String[]{"indexes"}, new Completor[]{new TableNameCompletor()}), new ReflectiveCommandHandler(new String[]{"primarykeys"}, new Completor[]{new TableNameCompletor()}), new ReflectiveCommandHandler(new String[]{"exportedkeys"}, new Completor[]{new TableNameCompletor()}), new ReflectiveCommandHandler(new String[]{"manual"}, null), new ReflectiveCommandHandler(new String[]{"importedkeys"}, new Completor[]{new TableNameCompletor()}), new ReflectiveCommandHandler(new String[]{"procedures"}, null), new ReflectiveCommandHandler(new String[]{"tables"}, null), new ReflectiveCommandHandler(new String[]{"typeinfo"}, null), new ReflectiveCommandHandler(new String[]{"columns"}, new Completor[]{new TableNameCompletor()}), new ReflectiveCommandHandler(new String[]{"reconnect"}, null), new ReflectiveCommandHandler(new String[]{"dropall"}, new Completor[]{new TableNameCompletor()}), new ReflectiveCommandHandler(new String[]{"history"}, null), new ReflectiveCommandHandler(new String[]{"metadata"}, new Completor[]{new SimpleCompletor(this.getMetadataMethodNames())}), new ReflectiveCommandHandler(new String[]{"nativesql"}, null), new ReflectiveCommandHandler(new String[]{"dbinfo"}, null), new ReflectiveCommandHandler(new String[]{"rehash"}, null), new ReflectiveCommandHandler(new String[]{"verbose"}, null), new ReflectiveCommandHandler(new String[]{"run"}, new Completor[]{new FileNameCompletor()}), new ReflectiveCommandHandler(new String[]{"batch"}, null), new ReflectiveCommandHandler(new String[]{"list"}, null), new ReflectiveCommandHandler(new String[]{"all"}, null), new ReflectiveCommandHandler(new String[]{"go", "#"}, null), new ReflectiveCommandHandler(new String[]{"script"}, new Completor[]{new FileNameCompletor()}), new ReflectiveCommandHandler(new String[]{"record"}, new Completor[]{new FileNameCompletor()}), new ReflectiveCommandHandler(new String[]{"brief"}, null), new ReflectiveCommandHandler(new String[]{"close"}, null), new ReflectiveCommandHandler(new String[]{"closeall"}, null), new ReflectiveCommandHandler(new String[]{"isolation"}, new Completor[]{new SimpleCompletor(this.getIsolationLevels())}), new ReflectiveCommandHandler(new String[]{"outputformat"}, new Completor[]{new SimpleCompletor(this.formats.keySet().toArray(new String[0]))}), new ReflectiveCommandHandler(new String[]{"autocommit"}, null), new ReflectiveCommandHandler(new String[]{"commit"}, null), new ReflectiveCommandHandler(new String[]{"properties"}, new Completor[]{new FileNameCompletor()}), new ReflectiveCommandHandler(new String[]{"rollback"}, null), new ReflectiveCommandHandler(new String[]{"help", "?"}, null), new ReflectiveCommandHandler(new String[]{"set"}, this.opts.optionCompletors()), new ReflectiveCommandHandler(new String[]{"save"}, null), new ReflectiveCommandHandler(new String[]{"scan"}, null), new ReflectiveCommandHandler(new String[]{"sql"}, null), new ReflectiveCommandHandler(new String[]{"call"}, null)};
    static final SortedSet KNOWN_DRIVERS = new TreeSet<String>(Arrays.asList("com.merant.datadirect.jdbc.sqlserver.SQLServerDriver", "com.microsoft.jdbc.sqlserver.SQLServerDriver", "com.ddtek.jdbc.informix.InformixDriver", "org.sourceforge.jxdbcon.JXDBConDriver", "com.ddtek.jdbc.oracle.OracleDriver", "net.sourceforge.jtds.jdbc.Driver", "com.pointbase.jdbc.jdbcDriver", "com.internetcds.jdbc.tds.SybaseDriver", "org.enhydra.instantdb.jdbc.idbDriver", "com.sybase.jdbc2.jdbc.SybDriver", "com.ddtek.jdbc.sybase.SybaseDriver", "COM.cloudscape.core.JDBCDriver", "in.co.daffodil.db.jdbc.DaffodilDBDriver", "com.jnetdirect.jsql.JSQLDriver", "COM.ibm.db2.jdbc.net.DB2Driver", "org.hsqldb.jdbcDriver", "com.pointbase.jdbc.jdbcUniversalDriver", "com.ddtek.jdbc.sqlserver.SQLServerDriver", "com.ddtek.jdbc.db2.DB2Driver", "com.merant.datadirect.jdbc.oracle.OracleDriver", "oracle.jdbc.OracleDriver", "com.informix.jdbc.IfxDriver", "com.merant.datadirect.jdbc.informix.InformixDriver", "com.ibm.db2.jcc.DB2Driver", "com.pointbase.jdbc.jdbcEmbeddedDriver", "org.gjt.mm.mysql.Driver", "org.postgresql.Driver", "com.mysql.jdbc.Driver", "oracle.jdbc.driver.OracleDriver", "interbase.interclient.Driver", "com.mysql.jdbc.NonRegisteringDriver", "com.merant.datadirect.jdbc.db2.DB2Driver", "com.merant.datadirect.jdbc.sybase.SybaseDriver", "com.internetcds.jdbc.tds.Driver", "org.hsqldb.jdbcDriver", "org.hsql.jdbcDriver", "COM.cloudscape.core.JDBCDriver", "in.co.daffodil.db.jdbc.DaffodilDBDriver", "com.ddtek.jdbc.db2.DB2Driver", "interbase.interclient.Driver", "com.mysql.jdbc.Driver", "com.ddtek.jdbc.oracle.OracleDriver", "org.postgresql.Driver", "com.pointbase.jdbc.jdbcUniversalDriver", "org.sourceforge.jxdbcon.JXDBConDriver", "com.ddtek.jdbc.sqlserver.SQLServerDriver", "com.jnetdirect.jsql.JSQLDriver", "com.microsoft.jdbc.sqlserver.SQLServerDriver", "weblogic.jdbc.mssqlserver4.Driver", "com.ddtek.jdbc.sybase.SybaseDriver", "oracle.jdbc.pool.OracleDataSource", "org.axiondb.jdbc.AxionDriver", "COM.ibm.db2.jdbc.app.DB2Driver", "com.ibm.as400.access.AS400JDBCDriver", "COM.FirstSQL.Dbcp.DbcpDriver", "COM.ibm.db2.jdbc.net.DB2Driver", "org.enhydra.instantdb.jdbc.idbDriver", "com.informix.jdbc.IfxDriver", "com.microsoft.jdbc.sqlserver.SQLServerDriver", "com.imaginary.sql.msql.MsqlDriver", "sun.jdbc.odbc.JdbcOdbcDriver", "oracle.jdbc.driver.OracleDriver", "intersolv.jdbc.sequelink.SequeLinkDriver", "openlink.jdbc2.Driver", "com.pointbase.jdbc.jdbcUniversalDriver", "postgres95.PGDriver", "postgresql.Driver", "solid.jdbc.SolidDriver", "centura.java.sqlbase.SqlbaseDriver", "interbase.interclient.Driver", "com.mckoi.JDBCDriver", "com.inet.tds.TdsDriver", "com.microsoft.jdbc.sqlserver.SQLServerDriver", "com.thinweb.tds.Driver", "weblogic.jdbc.mssqlserver4.Driver", "com.mysql.jdbc.DatabaseMetaData", "org.gjt.mm.mysql.Driver", "com.sap.dbtech.jdbc.DriverSapDB", "com.sybase.jdbc2.jdbc.SybDriver", "com.sybase.jdbc.SybDriver", "com.internetcds.jdbc.tds.Driver", "weblogic.jdbc.pool.Driver"));
    static /* synthetic */ Class class$sqlline$SqlLine;
    static /* synthetic */ Class class$java$sql$DatabaseMetaData;
    static /* synthetic */ Class class$java$sql$Driver;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$sqlline$SqlLine$SQLLineSQLCompletor;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$sqlline$SqlLine$DriverInfo;

    static Manifest getManifest() throws IOException {
        URL uRL = (class$sqlline$SqlLine == null ? (class$sqlline$SqlLine = SqlLine.class$("sqlline.SqlLine")) : class$sqlline$SqlLine).getResource("/META-INF/MANIFEST.MF");
        URLConnection uRLConnection = uRL.openConnection();
        if (uRLConnection instanceof JarURLConnection) {
            return ((JarURLConnection)uRLConnection).getManifest();
        }
        return null;
    }

    static String getManifestAttribute(String string) {
        try {
            Manifest manifest = SqlLine.getManifest();
            if (manifest == null) {
                return "??";
            }
            Attributes attributes = manifest.getAttributes("sqlline");
            if (attributes == null) {
                return "???";
            }
            String string2 = attributes.getValue(string);
            if (string2 == null || "".equals(string2)) {
                return "????";
            }
            return string2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "?????";
        }
    }

    static String getApplicationTitle() {
        Package package_ = (class$sqlline$SqlLine == null ? (class$sqlline$SqlLine = SqlLine.class$("sqlline.SqlLine")) : class$sqlline$SqlLine).getPackage();
        return SqlLine.loc("app-introduction", new Object[]{package_.getImplementationTitle() == null ? "sqlline" : package_.getImplementationTitle(), package_.getImplementationVersion() == null ? "???" : package_.getImplementationVersion(), package_.getImplementationVendor() == null ? "Marc Prud'hommeaux" : package_.getImplementationVendor()});
    }

    static String getApplicationContactInformation() {
        return SqlLine.getManifestAttribute("Implementation-Vendor");
    }

    static String loc(String string) {
        return SqlLine.loc(string, new Object[0]);
    }

    static String loc(String string, int n) {
        try {
            return MessageFormat.format(new ChoiceFormat(loc.getString(string)).format(n), new Integer(n));
        }
        catch (Exception exception) {
            return string + ": " + n;
        }
    }

    static String loc(String string, Object object) {
        return SqlLine.loc(string, new Object[]{object});
    }

    static String loc(String string, Object object, Object object2) {
        return SqlLine.loc(string, new Object[]{object, object2});
    }

    static String loc(String string, Object[] objectArray) {
        try {
            return MessageFormat.format(loc.getString(string), objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            try {
                return string + ": " + Arrays.asList(objectArray);
            }
            catch (Exception exception2) {
                return string;
            }
        }
    }

    public static void main(String[] stringArray) throws IOException {
        SqlLine.mainWithInputRedirection(stringArray, null);
    }

    public static void mainWithInputRedirection(String[] stringArray, InputStream inputStream) throws IOException {
        SqlLine sqlLine = new SqlLine();
        sqlLine.begin(stringArray, inputStream);
        if (!Boolean.getBoolean("sqlline.system.exit")) {
            System.exit(0);
        }
    }

    SqlLine() {
        this.sqlLineCommandCompletor = new SQLLineCommandCompletor();
    }

    DatabaseConnection con() {
        return this.connections.current();
    }

    Connection conn() {
        if (this.connections.current() == null) {
            throw new IllegalArgumentException(SqlLine.loc("no-current-connection"));
        }
        if (this.connections.current().connection == null) {
            throw new IllegalArgumentException(SqlLine.loc("no-current-connection"));
        }
        return this.connections.current().connection;
    }

    DatabaseMetaData meta() {
        if (this.connections.current() == null) {
            throw new IllegalArgumentException(SqlLine.loc("no-current-connection"));
        }
        if (this.connections.current().meta == null) {
            throw new IllegalArgumentException(SqlLine.loc("no-current-connection"));
        }
        return this.connections.current().meta;
    }

    public String[] getIsolationLevels() {
        return new String[]{"TRANSACTION_NONE", "TRANSACTION_READ_COMMITTED", "TRANSACTION_READ_UNCOMMITTED", "TRANSACTION_REPEATABLE_READ", "TRANSACTION_SERIALIZABLE"};
    }

    public String[] getMetadataMethodNames() {
        try {
            TreeSet<String> treeSet = new TreeSet<String>();
            Method[] methodArray = (class$java$sql$DatabaseMetaData == null ? (class$java$sql$DatabaseMetaData = SqlLine.class$("java.sql.DatabaseMetaData")) : class$java$sql$DatabaseMetaData).getDeclaredMethods();
            for (int i = 0; methodArray != null && i < methodArray.length; ++i) {
                treeSet.add(methodArray[i].getName());
            }
            return treeSet.toArray(new String[0]);
        }
        catch (Throwable throwable) {
            return new String[0];
        }
    }

    public String[] getConnectionURLExamples() {
        return new String[]{"jdbc:JSQLConnect://<hostname>/database=<database>", "jdbc:cloudscape:<database>;create=true", "jdbc:twtds:sqlserver://<hostname>/<database>", "jdbc:daffodilDB_embedded:<database>;create=true", "jdbc:datadirect:db2://<hostname>:50000;databaseName=<database>", "jdbc:inetdae:<hostname>:1433", "jdbc:datadirect:oracle://<hostname>:1521;SID=<database>;MaxPooledStatements=0", "jdbc:datadirect:sqlserver://<hostname>:1433;SelectMethod=cursor;DatabaseName=<database>", "jdbc:datadirect:sybase://<hostname>:5000", "jdbc:db2://<hostname>/<database>", "jdbc:hsqldb:<database>", "jdbc:idb:<database>.properties", "jdbc:informix-sqli://<hostname>:1526/<database>:INFORMIXSERVER=<database>", "jdbc:interbase://<hostname>//<database>.gdb", "jdbc:microsoft:sqlserver://<hostname>:1433;DatabaseName=<database>;SelectMethod=cursor", "jdbc:mysql://<hostname>/<database>?autoReconnect=true", "jdbc:oracle:thin:@<hostname>:1521:<database>", "jdbc:pointbase:<database>,database.home=<database>,create=true", "jdbc:postgresql://<hostname>:5432/<database>", "jdbc:postgresql:net//<hostname>/<database>", "jdbc:sybase:Tds:<hostname>:4100/<database>?ServiceName=<database>", "jdbc:weblogic:mssqlserver4:<database>@<hostname>:1433", "jdbc:odbc:<database>", "jdbc:sequelink://<hostname>:4003/[Oracle]", "jdbc:sequelink://<hostname>:4004/[Informix];Database=<database>", "jdbc:sequelink://<hostname>:4005/[Sybase];Database=<database>", "jdbc:sequelink://<hostname>:4006/[SQLServer];Database=<database>", "jdbc:sequelink://<hostname>:4011/[ODBC MS Access];Database=<database>", "jdbc:openlink://<hostname>/DSN=SQLServerDB/UID=sa/PWD=", "jdbc:solid://<hostname>:<port>/<UID>/<PWD>", "jdbc:dbaw://<hostname>:8889/<database>"};
    }

    ColorBuffer color() {
        return new ColorBuffer(this.opts.getColor());
    }

    ColorBuffer color(String string) {
        return new ColorBuffer(string, this.opts.getColor());
    }

    void registerKnownDrivers() {
        Iterator iterator = KNOWN_DRIVERS.iterator();
        while (iterator.hasNext()) {
            try {
                Class.forName(iterator.next().toString());
            }
            catch (Throwable throwable) {}
        }
    }

    boolean initArgs(String[] stringArray) {
        Object object;
        LinkedList<String> linkedList = new LinkedList<String>();
        LinkedList<String> linkedList2 = new LinkedList<String>();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        Object var8_8 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("--help") || stringArray[i].equals("-h")) {
                this.usage();
                return false;
            }
            if (stringArray[i].startsWith("--")) {
                boolean bl;
                object = this.split(stringArray[i].substring(2), "=");
                this.debug(SqlLine.loc("setting-prop", Arrays.asList(object)));
                if (((String[])object).length <= 0 || (bl = ((String[])object).length >= 2 ? this.opts.set(object[0], object[1], true) : this.opts.set(object[0], "true", true))) continue;
                return false;
            }
            if (stringArray[i].equals("-d")) {
                string = stringArray[i++ + 1];
                continue;
            }
            if (stringArray[i].equals("-n")) {
                string2 = stringArray[i++ + 1];
                continue;
            }
            if (stringArray[i].equals("-p")) {
                string3 = stringArray[i++ + 1];
                continue;
            }
            if (stringArray[i].equals("-u")) {
                string4 = stringArray[i++ + 1];
                continue;
            }
            if (stringArray[i].equals("-e")) {
                linkedList.add(stringArray[i++ + 1]);
                continue;
            }
            linkedList2.add(stringArray[i]);
        }
        if (string4 != null) {
            String string5 = "!connect " + string4 + " " + (string2 == null || string2.length() == 0 ? "''" : string2) + " " + (string3 == null || string3.length() == 0 ? "''" : string3) + " " + (string == null ? "" : string);
            this.debug("issuing: " + string5);
            this.dispatch(string5);
        }
        Iterator iterator = linkedList2.iterator();
        while (iterator.hasNext()) {
            this.dispatch("!properties " + iterator.next());
        }
        if (linkedList.size() > 0) {
            this.opts.setColor(false);
            this.opts.setHeaderInterval(-1);
            iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                object = iterator.next().toString();
                this.debug(SqlLine.loc("executing-command", object));
                this.dispatch((String)object);
            }
            this.exit = true;
        }
        return true;
    }

    void begin(String[] stringArray, InputStream inputStream) throws IOException {
        try {
            this.opts.load();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ConsoleReader consoleReader = this.getConsoleReader(inputStream);
        if (!this.initArgs(stringArray)) {
            this.usage();
            return;
        }
        try {
            this.info(SqlLine.getApplicationTitle());
        }
        catch (Exception exception) {
            // empty catch block
        }
        while (!this.exit) {
            try {
                this.dispatch(consoleReader.readLine(this.getPrompt()));
            }
            catch (EOFException eOFException) {
                this.command.quit(null);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        this.command.closeall(null);
    }

    public ConsoleReader getConsoleReader(InputStream inputStream) throws IOException {
        Closeable closeable;
        Terminal terminal = Terminal.setupTerminal();
        this.reader = inputStream != null ? new ConsoleReader(inputStream, (Writer)new PrintWriter(System.out)) : new ConsoleReader();
        ByteArrayInputStream byteArrayInputStream = null;
        if (new File(this.opts.getHistoryFile()).isFile()) {
            try {
                int n;
                closeable = new FileInputStream(this.opts.getHistoryFile());
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                while ((n = ((FileInputStream)closeable).read()) != -1) {
                    byteArrayOutputStream.write(n);
                }
                ((FileInputStream)closeable).close();
                byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            }
            catch (Exception exception) {
                this.handleException(exception);
            }
        }
        try {
            closeable = new PrintWriter(new FileWriter(this.opts.getHistoryFile()));
            this.reader.getHistory().setOutput((PrintWriter)closeable);
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        try {
            if (byteArrayInputStream != null) {
                this.reader.getHistory().load(byteArrayInputStream);
            }
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        this.reader.addCompletor((Completor)new SQLLineCompletor());
        return this.reader;
    }

    void usage() {
        this.output(SqlLine.loc("cmd-usage"));
    }

    boolean dispatch(String string) {
        if (string == null) {
            this.exit = true;
            return true;
        }
        if (string.trim().length() == 0) {
            return true;
        }
        if (this.isComment(string)) {
            return true;
        }
        string = string.trim();
        if (this.script != null) {
            this.script.addLine(string);
        }
        if (this.isHelpRequest(string)) {
            string = "!help";
        }
        if (string.startsWith(COMMAND_PREFIX)) {
            TreeMap<String, CommandHandler> treeMap = new TreeMap<String, CommandHandler>();
            string = string.substring(1);
            for (int i = 0; i < this.commands.length; ++i) {
                String string2 = this.commands[i].matches(string);
                if (string2 == null) continue;
                treeMap.put(string2, this.commands[i]);
            }
            if (treeMap.size() == 0) {
                return this.error(SqlLine.loc("unknown-command", string));
            }
            if (treeMap.size() > 1) {
                return this.error(SqlLine.loc("multiple-matches", treeMap.keySet().toString()));
            }
            return ((CommandHandler)treeMap.values().iterator().next()).execute(string);
        }
        return this.command.sql(string);
    }

    boolean needsContinuation(String string) {
        if (this.isHelpRequest(string)) {
            return false;
        }
        if (string.startsWith(COMMAND_PREFIX)) {
            return false;
        }
        if (this.isComment(string)) {
            return false;
        }
        String string2 = string.trim();
        if (string2.length() == 0) {
            return false;
        }
        return !string2.endsWith(";");
    }

    boolean isHelpRequest(String string) {
        return string.equals("?") || string.equalsIgnoreCase("help");
    }

    boolean isComment(String string) {
        return string.startsWith("#") || string.startsWith("--");
    }

    void output(String string) {
        this.output(string, true);
    }

    void info(String string) {
        if (!this.opts.getSilent()) {
            this.output(string, true, System.err);
        }
    }

    void info(ColorBuffer colorBuffer) {
        if (!this.opts.getSilent()) {
            this.output(colorBuffer, true, System.err);
        }
    }

    boolean error(String string) {
        this.output(this.color().red(string), true, System.err);
        return false;
    }

    boolean error(Throwable throwable) {
        this.handleException(throwable);
        return false;
    }

    void debug(String string) {
        if (this.opts.getVerbose()) {
            this.output(this.color().blue(string), true, System.err);
        }
    }

    void output(ColorBuffer colorBuffer) {
        this.output(colorBuffer, true);
    }

    void output(String string, boolean bl, PrintStream printStream) {
        this.output(this.color(string), bl, printStream);
    }

    void output(ColorBuffer colorBuffer, boolean bl) {
        this.output(colorBuffer, bl, System.out);
    }

    void output(ColorBuffer colorBuffer, boolean bl, PrintStream printStream) {
        if (bl) {
            printStream.println(colorBuffer.getColor());
        } else {
            printStream.print(colorBuffer.getColor());
        }
        if (this.record == null) {
            return;
        }
        if (bl) {
            this.record.addLine(colorBuffer.getMono());
        }
    }

    void output(String string, boolean bl) {
        this.output(this.color(string), bl);
    }

    void autocommitStatus(Connection connection) throws SQLException {
        this.info(SqlLine.loc("autocommit-status", connection.getAutoCommit() + ""));
    }

    boolean assertAutoCommit() {
        if (!this.assertConnection()) {
            return false;
        }
        try {
            if (this.con().connection.getAutoCommit()) {
                return this.error(SqlLine.loc("autocommit-needs-off"));
            }
        }
        catch (Exception exception) {
            return this.error(exception);
        }
        return true;
    }

    boolean assertConnection() {
        try {
            if (this.con() == null || this.con().connection == null) {
                return this.error(SqlLine.loc("no-current-connection"));
            }
            if (this.con().connection.isClosed()) {
                return this.error(SqlLine.loc("connection-is-closed"));
            }
        }
        catch (SQLException sQLException) {
            return this.error(SqlLine.loc("no-current-connection"));
        }
        return true;
    }

    void showWarnings() {
        if (this.con().connection == null) {
            return;
        }
        if (!this.opts.getVerbose()) {
            return;
        }
        try {
            this.showWarnings(this.con().connection.getWarnings());
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    void showWarnings(SQLWarning sQLWarning) {
        SQLWarning sQLWarning2;
        if (sQLWarning == null) {
            return;
        }
        if (this.seenWarnings.get(sQLWarning) == null) {
            this.seenWarnings.put(sQLWarning, new Date());
            this.handleSQLException(sQLWarning);
        }
        if ((sQLWarning2 = sQLWarning.getNextWarning()) != sQLWarning) {
            this.showWarnings(sQLWarning2);
        }
    }

    String getPrompt() {
        if (this.con() == null || this.con().url == null) {
            return "sqlline> ";
        }
        return SqlLine.getPrompt(this.connections.getIndex() + ": " + this.con().url) + "> ";
    }

    static String getPrompt(String string) {
        if (string == null || string.length() == 0) {
            string = "sqlline";
        }
        if (string.indexOf(";") > -1) {
            string = string.substring(0, string.indexOf(";"));
        }
        if (string.indexOf("?") > -1) {
            string = string.substring(0, string.indexOf("?"));
        }
        if (string.length() > 45) {
            string = string.substring(0, 45);
        }
        return string;
    }

    int getSize(ResultSet resultSet) {
        try {
            if (resultSet.getType() == 1003) {
                return -1;
            }
            resultSet.last();
            int n = resultSet.getRow();
            resultSet.beforeFirst();
            return n;
        }
        catch (SQLException sQLException) {
            return -1;
        }
        catch (AbstractMethodError abstractMethodError) {
            return -1;
        }
    }

    ResultSet getColumns(String string) throws SQLException {
        if (!this.assertConnection()) {
            return null;
        }
        return this.con().meta.getColumns(this.con().meta.getConnection().getCatalog(), null, string, "%");
    }

    ResultSet getTables() throws SQLException {
        if (!this.assertConnection()) {
            return null;
        }
        return this.con().meta.getTables(this.con().meta.getConnection().getCatalog(), null, "%", new String[]{"TABLE"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getColumnNames(DatabaseMetaData databaseMetaData) throws SQLException {
        HashSet<String> hashSet = new HashSet<String>();
        this.info(SqlLine.loc("building-tables"));
        try {
            ResultSet resultSet = this.getColumns("%");
            try {
                int n = this.getSize(resultSet);
                int n2 = 0;
                while (resultSet.next()) {
                    this.progress(n2++, n);
                    String string = resultSet.getString("TABLE_NAME");
                    hashSet.add(string);
                    hashSet.add(resultSet.getString("COLUMN_NAME"));
                    hashSet.add(resultSet.getString("TABLE_NAME") + "." + resultSet.getString("COLUMN_NAME"));
                }
                this.progress(n2, n2);
            }
            finally {
                resultSet.close();
            }
            this.info(SqlLine.loc("done"));
            return hashSet.toArray(new String[0]);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
            return new String[0];
        }
    }

    String[] split(String string) {
        return this.split(string, " ");
    }

    String dequote(String string) {
        if (string == null) {
            return null;
        }
        while (string.startsWith("'") && string.endsWith("'") || string.startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    String[] split(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            string3 = this.dequote(string3);
            stringArray[n++] = string3;
        }
        return stringArray;
    }

    static Map map(Object[] objectArray) {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        for (int i = 0; i < objectArray.length - 1; i += 2) {
            hashMap.put(objectArray[i], objectArray[i + 1]);
        }
        return Collections.unmodifiableMap(hashMap);
    }

    static boolean getMoreResults(Statement statement) {
        try {
            return statement.getMoreResults();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    static String xmlattrencode(String string) {
        string = SqlLine.replace(string, "\"", "&quot;");
        string = SqlLine.replace(string, "<", "&lt;");
        return string;
    }

    static String replace(String string, String string2, String string3) {
        if (string == null) {
            return null;
        }
        if (string2.equals(string3)) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = -1;
        while ((n = string.indexOf(string2)) != -1) {
            stringBuffer.append(string.substring(0, n));
            stringBuffer.append(string3);
            string = string.substring(n + string2.length());
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    String[] split(String string, int n, String string2) {
        String[] stringArray = this.split(string);
        if (stringArray.length != n) {
            this.error(string2);
            return null;
        }
        return stringArray;
    }

    String wrap(String string, int n, int n2) {
        String string2 = string;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        char[] cArray = new char[n2];
        Arrays.fill(cArray, ' ');
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (stringBuffer2.length() + string3.length() > n) {
                stringBuffer.append(stringBuffer2).append(sep).append(cArray);
                stringBuffer2.setLength(0);
            }
            stringBuffer2.append(stringBuffer2.length() == 0 ? "" : " ").append(string3);
        }
        stringBuffer.append(stringBuffer2);
        return stringBuffer.toString();
    }

    void progress(int n, int n2) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.lastProgress != null) {
            object = new char[this.lastProgress.length()];
            Arrays.fill(object, '\b');
            stringBuffer.append((char[])object);
        }
        object = n + "/" + (n2 == -1 ? "?" : "" + n2) + " " + (n2 == -1 ? "(??%)" : "(" + n * 100 / (n2 == 0 ? 1 : n2) + "%)");
        if (n >= n2 && n2 != -1) {
            object = (String)object + " " + SqlLine.loc("done") + sep;
            this.lastProgress = null;
        } else {
            this.lastProgress = object;
        }
        stringBuffer.append((String)object);
        System.out.print(stringBuffer.toString());
        System.out.flush();
    }

    void handleException(Throwable throwable) {
        while (throwable instanceof InvocationTargetException) {
            throwable = ((InvocationTargetException)throwable).getTargetException();
        }
        if (throwable instanceof SQLException) {
            this.handleSQLException((SQLException)throwable);
        } else if (!this.opts.getVerbose()) {
            if (throwable.getMessage() == null) {
                this.error(throwable.getClass().getName());
            } else {
                this.error(throwable.getMessage());
            }
        } else {
            throwable.printStackTrace(System.err);
        }
    }

    void handleSQLException(SQLException sQLException) {
        if (sQLException instanceof SQLWarning && !this.opts.getShowWarnings()) {
            return;
        }
        String string = sQLException instanceof SQLWarning ? SqlLine.loc("Warning") : SqlLine.loc("Error");
        this.error(SqlLine.loc(sQLException instanceof SQLWarning ? "Warning" : "Error", new Object[]{sQLException.getMessage() == null ? "" : sQLException.getMessage().trim(), sQLException.getSQLState() == null ? "" : sQLException.getSQLState().trim(), new Integer(sQLException.getErrorCode())}));
        if (this.opts.getVerbose()) {
            sQLException.printStackTrace();
        }
        for (SQLException sQLException2 = sQLException.getNextException(); sQLException2 != null && sQLException2 != sQLException; sQLException2 = sQLException2.getNextException()) {
            this.handleSQLException(sQLException2);
        }
    }

    private boolean scanForDriver(String string) {
        try {
            if (this.findRegisteredDriver(string) != null) {
                return true;
            }
            this.scanDrivers(true);
            if (this.findRegisteredDriver(string) != null) {
                return true;
            }
            this.scanDrivers(false);
            return this.findRegisteredDriver(string) != null;
        }
        catch (Exception exception) {
            this.debug(exception.toString());
            return false;
        }
    }

    private Driver findRegisteredDriver(String string) {
        Enumeration<Driver> enumeration = DriverManager.getDrivers();
        while (enumeration != null && enumeration.hasMoreElements()) {
            Driver driver = enumeration.nextElement();
            try {
                if (!driver.acceptsURL(string)) continue;
                return driver;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    Driver[] scanDrivers(String string) throws IOException {
        return this.scanDrivers(false);
    }

    Driver[] scanDrivers(boolean bl) throws IOException {
        long l = System.currentTimeMillis();
        HashSet<String> hashSet = new HashSet<String>();
        if (!bl) {
            hashSet.addAll(Arrays.asList(ClassNameCompletor.getClassNames()));
        }
        hashSet.addAll(KNOWN_DRIVERS);
        HashSet hashSet2 = new HashSet();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            if (string.toLowerCase().indexOf("driver") == -1) continue;
            try {
                Class<?> clazz = Class.forName(string, false, Thread.currentThread().getContextClassLoader());
                if (!(class$java$sql$Driver == null ? SqlLine.class$("java.sql.Driver") : class$java$sql$Driver).isAssignableFrom(clazz) || Modifier.isAbstract(clazz.getModifiers())) continue;
                hashSet2.add(clazz.newInstance());
            }
            catch (Throwable throwable) {}
        }
        this.info("scan complete in " + (System.currentTimeMillis() - l) + "ms");
        return hashSet2.toArray(new Driver[0]);
    }

    Driver[] scanDriversOLD(String string) {
        Object object;
        long l = System.currentTimeMillis();
        HashSet<String> hashSet = new HashSet<String>();
        HashSet hashSet2 = new HashSet();
        Object object2 = new StringTokenizer(System.getProperty("java.ext.dirs"), System.getProperty("path.separator"));
        while (((StringTokenizer)object2).hasMoreTokens()) {
            object = new File(((StringTokenizer)object2).nextToken()).listFiles();
            for (int i = 0; object != null && i < ((File[])object).length; ++i) {
                hashSet.add(object[i].getAbsolutePath());
            }
        }
        object2 = new StringTokenizer(System.getProperty("java.class.path"), System.getProperty("path.separator"));
        while (((StringTokenizer)object2).hasMoreTokens()) {
            hashSet.add(new File(((StringTokenizer)object2).nextToken()).getAbsolutePath());
        }
        object2 = hashSet.iterator();
        while (object2.hasNext()) {
            object = new File((String)object2.next());
            this.output(this.color().pad(SqlLine.loc("scanning", ((File)object).getAbsolutePath()), 60), false);
            try {
                ZipFile zipFile = new ZipFile((File)object);
                int n = zipFile.size();
                int n2 = 0;
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                while (enumeration.hasMoreElements()) {
                    ZipEntry zipEntry = enumeration.nextElement();
                    String string2 = zipEntry.getName();
                    this.progress(n2++, n);
                    if (!string2.endsWith(".class")) continue;
                    string2 = string2.replace('/', '.');
                    string2 = string2.substring(0, string2.length() - 6);
                    try {
                        Class<?> clazz;
                        if (string2.toLowerCase().indexOf("driver") == -1 || !(class$java$sql$Driver == null ? SqlLine.class$("java.sql.Driver") : class$java$sql$Driver).isAssignableFrom(clazz = Class.forName(string2, false, this.getClass().getClassLoader())) || Modifier.isAbstract(clazz.getModifiers())) continue;
                        try {
                            Class.forName(string2);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        hashSet2.add(clazz.newInstance());
                    }
                    catch (Throwable throwable) {}
                }
                this.progress(n, n);
            }
            catch (Exception exception) {}
        }
        this.info("scan complete in " + (System.currentTimeMillis() - l) + "ms");
        return hashSet2.toArray(new Driver[0]);
    }

    int print(ResultSet resultSet) throws SQLException {
        String string = this.opts.getOutputFormat();
        OutputFormat outputFormat = (OutputFormat)this.formats.get(string);
        if (outputFormat == null) {
            this.error(SqlLine.loc("unknown-format", new Object[]{string, this.formats.keySet()}));
            outputFormat = new TableOutputFormat();
        }
        Rows rows = this.opts.getIncremental() ? new IncrementalRows(resultSet) : new BufferedRows(resultSet);
        return outputFormat.print(rows);
    }

    private Statement createStatement() throws SQLException {
        Statement statement = this.con().connection.createStatement();
        if (this.opts.timeout > -1) {
            statement.setQueryTimeout(this.opts.timeout);
        }
        return statement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runBatch(List list) {
        try {
            Statement statement = this.createStatement();
            try {
                Object object = list.iterator();
                while (object.hasNext()) {
                    statement.addBatch(object.next().toString());
                }
                object = statement.executeBatch();
                this.output(this.color().pad(this.color().bold("COUNT"), 8).append(this.color().bold("STATEMENT")));
                for (int i = 0; object != null && i < ((Object)object).length; ++i) {
                    this.output(this.color().pad((int)object[i] + "", 8).append(list.get(i).toString()));
                }
            }
            finally {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    public int runCommands(List list) {
        int n = 0;
        try {
            int n2 = 1;
            int n3 = list.size();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                this.info(this.color().pad(n2++ + "/" + n3, 13).append(string));
                boolean bl = this.dispatch(string);
                if (!bl && !this.opts.getForce()) {
                    this.error(SqlLine.loc("abort-on-error", string));
                    return n;
                }
                n += bl ? 1 : 0;
            }
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        return n;
    }

    private void setCompletions() throws SQLException, IOException {
        if (this.con() != null) {
            this.con().setCompletions(this.opts.getFastConnect());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            Class<?> clazz = Class.forName("jline.ConsoleReader");
        }
        catch (Throwable throwable) {
            throw new ExceptionInInitializerError(SqlLine.loc("jline-missing"));
        }
    }

    static class DriverInfo {
        public String sampleURL;

        public DriverInfo(String string) throws IOException {
            Properties properties = new Properties();
            properties.load((class$sqlline$SqlLine$DriverInfo == null ? (class$sqlline$SqlLine$DriverInfo = SqlLine.class$("sqlline.SqlLine$DriverInfo")) : class$sqlline$SqlLine$DriverInfo).getResourceAsStream(string));
            this.fromProperties(properties);
        }

        public DriverInfo(Properties properties) {
            this.fromProperties(properties);
        }

        public void fromProperties(Properties properties) {
        }
    }

    public class OutputFile {
        final File file;
        final PrintWriter out;

        public OutputFile(String string) throws IOException {
            this.file = new File(string);
            this.out = new PrintWriter(new FileWriter(this.file));
        }

        public String toString() {
            return this.file.getAbsolutePath();
        }

        public void addLine(String string) {
            this.out.println(string);
        }

        public void close() throws IOException {
            this.out.close();
        }
    }

    static class Reflector {
        Reflector() {
        }

        public static Object invoke(Object object, String string, Object[] objectArray) throws InvocationTargetException, IllegalAccessException, ClassNotFoundException {
            return Reflector.invoke(object, string, Arrays.asList(objectArray));
        }

        public static Object invoke(Object object, String string, List list) throws InvocationTargetException, IllegalAccessException, ClassNotFoundException {
            return Reflector.invoke(object, object == null ? null : object.getClass(), string, list);
        }

        public static Object invoke(Object object, Class clazz, String string, List list) throws InvocationTargetException, IllegalAccessException, ClassNotFoundException {
            Class<?> clazz2 = clazz != null ? clazz : object.getClass();
            LinkedList<Method> linkedList = new LinkedList<Method>();
            Method[] methodArray = clazz2.getMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                if (!methodArray[i].getName().equalsIgnoreCase(string)) continue;
                linkedList.add(methodArray[i]);
            }
            if (linkedList.size() == 0) {
                throw new IllegalArgumentException(SqlLine.loc("no-method", new Object[]{string, clazz2.getName()}));
            }
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                Object[] objectArray;
                Method method = (Method)iterator.next();
                Class[] classArray = method.getParameterTypes();
                if (classArray.length != list.size() || (objectArray = Reflector.convert(list, classArray)) == null || !Modifier.isPublic(method.getModifiers())) continue;
                return method.invoke(object, objectArray);
            }
            return null;
        }

        public static Object[] convert(List list, Class[] classArray) throws ClassNotFoundException {
            Object[] objectArray = new Object[list.size()];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = Reflector.convert(list.get(i), classArray[i]);
            }
            return objectArray;
        }

        public static Object convert(Object object, Class clazz) throws ClassNotFoundException {
            if (object == null || object.toString().equals("null")) {
                return null;
            }
            if (clazz == (class$java$lang$String == null ? (class$java$lang$String = SqlLine.class$("java.lang.String")) : class$java$lang$String)) {
                return new String(object.toString());
            }
            if (clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = SqlLine.class$("java.lang.Byte")) : class$java$lang$Byte) || clazz == Byte.TYPE) {
                return new Byte(object.toString());
            }
            if (clazz == (class$java$lang$Character == null ? (class$java$lang$Character = SqlLine.class$("java.lang.Character")) : class$java$lang$Character) || clazz == Character.TYPE) {
                return new Character(object.toString().charAt(0));
            }
            if (clazz == (class$java$lang$Short == null ? (class$java$lang$Short = SqlLine.class$("java.lang.Short")) : class$java$lang$Short) || clazz == Short.TYPE) {
                return new Short(object.toString());
            }
            if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = SqlLine.class$("java.lang.Integer")) : class$java$lang$Integer) || clazz == Integer.TYPE) {
                return new Integer(object.toString());
            }
            if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = SqlLine.class$("java.lang.Long")) : class$java$lang$Long) || clazz == Long.TYPE) {
                return new Long(object.toString());
            }
            if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = SqlLine.class$("java.lang.Double")) : class$java$lang$Double) || clazz == Double.TYPE) {
                return new Double(object.toString());
            }
            if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = SqlLine.class$("java.lang.Float")) : class$java$lang$Float) || clazz == Float.TYPE) {
                return new Float(object.toString());
            }
            if (clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = SqlLine.class$("java.lang.Boolean")) : class$java$lang$Boolean) || clazz == Boolean.TYPE) {
                return new Boolean(object.toString().equals("true") || object.toString().equals("true") || object.toString().equals("1") || object.toString().equals("on") || object.toString().equals("yes"));
            }
            if (clazz == (class$java$lang$Class == null ? (class$java$lang$Class = SqlLine.class$("java.lang.Class")) : class$java$lang$Class)) {
                return Class.forName(object.toString());
            }
            return null;
        }
    }

    class Opts
    implements Completor {
        private boolean autosave = false;
        private boolean silent = false;
        private boolean color = false;
        private boolean showHeader = true;
        private int headerInterval = 100;
        private boolean fastConnect = true;
        private boolean autoCommit = true;
        private boolean verbose = false;
        private boolean force = false;
        private boolean incremental = false;
        private boolean showWarnings = false;
        private int maxWidth = Terminal.setupTerminal().getTerminalWidth();
        private int maxHeight = Terminal.setupTerminal().getTerminalHeight();
        private int maxColumnWidth = 15;
        private int timeout = -1;
        private String isolation = "TRANSACTION_REPEATABLE_READ";
        private String outputFormat = "table";
        public static final String PROPERTY_PREFIX = "sqlline.";
        public static final String PROPERTY_NAME_EXIT = "sqlline.system.exit";
        private File rcFile = new File(this.saveDir(), "sqlline.properties");
        private String historyFile = new File(this.saveDir(), "history").getAbsolutePath();

        public Opts(Properties properties) {
            this.loadProperties(properties);
        }

        public Completor[] optionCompletors() {
            return new Completor[]{this};
        }

        public String[] possibleSettingValues() {
            LinkedList<String> linkedList = new LinkedList<String>();
            linkedList.addAll(Arrays.asList("yes", "no"));
            return linkedList.toArray(new String[linkedList.size()]);
        }

        public File saveDir() {
            String string = System.getProperty("sqlline.rcfile");
            if (string != null && string.length() > 0) {
                return new File(string);
            }
            File file = new File(System.getProperty("user.home"), (System.getProperty("os.name").toLowerCase().indexOf("windows") != -1 ? "" : ".") + "sqlline").getAbsoluteFile();
            try {
                file.mkdirs();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return file;
        }

        public int complete(String string, int n, List list) {
            try {
                return new SimpleCompletor(this.propertyNames()).complete(string, n, list);
            }
            catch (Throwable throwable) {
                return -1;
            }
        }

        public void save() throws IOException {
            FileOutputStream fileOutputStream = new FileOutputStream(this.rcFile);
            this.save(fileOutputStream);
            ((OutputStream)fileOutputStream).close();
        }

        public void save(OutputStream outputStream) throws IOException {
            try {
                Properties properties = this.toProperties();
                properties.remove("sqlline.maxwidth");
                properties.store(outputStream, SqlLine.getApplicationTitle());
            }
            catch (Exception exception) {
                SqlLine.this.handleException(exception);
            }
        }

        String[] propertyNames() throws IllegalAccessException, InvocationTargetException {
            TreeSet<String> treeSet = new TreeSet<String>();
            Method[] methodArray = this.getClass().getDeclaredMethods();
            for (int i = 0; methodArray != null && i < methodArray.length; ++i) {
                if (!methodArray[i].getName().startsWith("get") || methodArray[i].getParameterTypes().length != 0) continue;
                String string = methodArray[i].getName().substring(3).toLowerCase();
                treeSet.add(string);
            }
            return treeSet.toArray(new String[treeSet.size()]);
        }

        public Properties toProperties() throws IllegalAccessException, InvocationTargetException, ClassNotFoundException {
            Properties properties = new Properties();
            String[] stringArray = this.propertyNames();
            for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                properties.setProperty(PROPERTY_PREFIX + stringArray[i], Reflector.invoke((Object)this, "get" + stringArray[i], new Object[0]).toString());
            }
            SqlLine.this.debug("properties: " + properties.toString());
            return properties;
        }

        public void load() throws IOException {
            FileInputStream fileInputStream = new FileInputStream(this.rcFile);
            this.load(fileInputStream);
            ((InputStream)fileInputStream).close();
        }

        public void load(InputStream inputStream) throws IOException {
            Properties properties = new Properties();
            properties.load(inputStream);
            this.loadProperties(properties);
        }

        public void loadProperties(Properties properties) {
            Iterator<Object> iterator = properties.keySet().iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                if (string.equals(PROPERTY_NAME_EXIT) || !string.startsWith(PROPERTY_PREFIX)) continue;
                this.set(string.substring(PROPERTY_PREFIX.length()), properties.getProperty(string));
            }
        }

        public void set(String string, String string2) {
            this.set(string, string2, false);
        }

        public boolean set(String string, String string2, boolean bl) {
            try {
                Reflector.invoke((Object)this, "set" + string, new Object[]{string2});
                return true;
            }
            catch (Exception exception) {
                if (!bl) {
                    SqlLine.this.error(SqlLine.loc("error-setting", new Object[]{string, exception}));
                }
                return false;
            }
        }

        public void setFastConnect(boolean bl) {
            this.fastConnect = bl;
        }

        public boolean getFastConnect() {
            return this.fastConnect;
        }

        public void setAutoCommit(boolean bl) {
            this.autoCommit = bl;
        }

        public boolean getAutoCommit() {
            return this.autoCommit;
        }

        public void setVerbose(boolean bl) {
            this.verbose = bl;
        }

        public boolean getVerbose() {
            return this.verbose;
        }

        public void setShowWarnings(boolean bl) {
            this.showWarnings = bl;
        }

        public boolean getShowWarnings() {
            return this.showWarnings;
        }

        public void setMaxWidth(int n) {
            this.maxWidth = n;
        }

        public int getMaxWidth() {
            return this.maxWidth;
        }

        public void setMaxColumnWidth(int n) {
            this.maxColumnWidth = n;
        }

        public int getMaxColumnWidth() {
            return this.maxColumnWidth;
        }

        public void setTimeout(int n) {
            this.timeout = n;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public void setIsolation(String string) {
            this.isolation = string;
        }

        public String getIsolation() {
            return this.isolation;
        }

        public void setHistoryFile(String string) {
            this.historyFile = string;
        }

        public String getHistoryFile() {
            return this.historyFile;
        }

        public void setColor(boolean bl) {
            this.color = bl;
        }

        public boolean getColor() {
            return this.color;
        }

        public void setShowHeader(boolean bl) {
            this.showHeader = bl;
        }

        public boolean getShowHeader() {
            return this.showHeader;
        }

        public void setHeaderInterval(int n) {
            this.headerInterval = n;
        }

        public int getHeaderInterval() {
            return this.headerInterval;
        }

        public void setForce(boolean bl) {
            this.force = bl;
        }

        public boolean getForce() {
            return this.force;
        }

        public void setIncremental(boolean bl) {
            this.incremental = bl;
        }

        public boolean getIncremental() {
            return this.incremental;
        }

        public void setSilent(boolean bl) {
            this.silent = bl;
        }

        public boolean getSilent() {
            return this.silent;
        }

        public void setAutosave(boolean bl) {
            this.autosave = bl;
        }

        public boolean getAutosave() {
            return this.autosave;
        }

        public void setOutputFormat(String string) {
            this.outputFormat = string;
        }

        public String getOutputFormat() {
            return this.outputFormat;
        }

        public void setMaxHeight(int n) {
            this.maxHeight = n;
        }

        public int getMaxHeight() {
            return this.maxHeight;
        }
    }

    private class DatabaseConnection {
        Connection connection;
        DatabaseMetaData meta;
        private final String driver;
        private final String url;
        private final String username;
        private final String password;
        private Schema schema = null;
        private Completor sqlLineSQLCompletor = null;

        public DatabaseConnection(String string, String string2, String string3, String string4) throws SQLException {
            this.driver = string;
            this.url = string2;
            this.username = string3;
            this.password = string4;
        }

        public String toString() {
            return this.url + "";
        }

        private void setCompletions(boolean bl) throws SQLException, IOException {
            final String string = this.meta == null || this.meta.getExtraNameCharacters() == null ? "" : this.meta.getExtraNameCharacters();
            this.sqlLineSQLCompletor = new ArgumentCompletor((Completor)new SQLLineSQLCompletor(bl), (ArgumentCompletor.ArgumentDelimiter)new ArgumentCompletor.AbstractArgumentDelimiter(){

                public boolean isDelimiterChar(String string2, int n) {
                    char c = string2.charAt(n);
                    if (Character.isWhitespace(c)) {
                        return true;
                    }
                    return !Character.isLetterOrDigit(c) && c != '_' && string.indexOf(c) == -1;
                }
            });
            ((ArgumentCompletor)this.sqlLineSQLCompletor).setStrict(false);
        }

        boolean connect() throws SQLException {
            try {
                if (this.driver != null && this.driver.length() != 0) {
                    Class.forName(this.driver);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                return SqlLine.this.error(classNotFoundException);
            }
            boolean bl = false;
            try {
                bl = DriverManager.getDriver(this.url) != null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!bl) {
                SqlLine.this.output(SqlLine.loc("autoloading-known-drivers", this.url));
                SqlLine.this.registerKnownDrivers();
            }
            try {
                this.close();
            }
            catch (Exception exception) {
                return SqlLine.this.error(exception);
            }
            this.connection = DriverManager.getConnection(this.url, this.username, this.password);
            this.meta = this.connection.getMetaData();
            try {
                SqlLine.this.info(SqlLine.loc("connected", new Object[]{this.meta.getDatabaseProductName(), this.meta.getDatabaseProductVersion()}));
            }
            catch (Exception exception) {
                SqlLine.this.handleException(exception);
            }
            try {
                SqlLine.this.info(SqlLine.loc("driver", new Object[]{this.meta.getDriverName(), this.meta.getDriverVersion()}));
            }
            catch (Exception exception) {
                SqlLine.this.handleException(exception);
            }
            try {
                this.connection.setAutoCommit(SqlLine.this.opts.getAutoCommit());
                SqlLine.this.autocommitStatus(this.connection);
            }
            catch (Exception exception) {
                SqlLine.this.handleException(exception);
            }
            try {
                SqlLine.this.command.isolation("isolation: " + SqlLine.this.opts.getIsolation());
            }
            catch (Exception exception) {
                SqlLine.this.handleException(exception);
            }
            return true;
        }

        public Connection getConnection() throws SQLException {
            if (this.connection != null) {
                return this.connection;
            }
            this.connect();
            return this.connection;
        }

        public void reconnect() throws Exception {
            this.close();
            this.getConnection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            try {
                try {
                    if (this.connection != null && !this.connection.isClosed()) {
                        SqlLine.this.output(SqlLine.loc("closing", this.connection));
                        this.connection.close();
                    }
                }
                catch (Exception exception) {
                    SqlLine.this.handleException(exception);
                }
            }
            finally {
                this.connection = null;
                this.meta = null;
            }
        }

        public String[] getTableNames(boolean bl) {
            Schema.Table[] tableArray = this.getSchema().getTables();
            TreeSet<String> treeSet = new TreeSet<String>();
            for (int i = 0; tableArray != null && i < tableArray.length; ++i) {
                treeSet.add(tableArray[i].getName());
            }
            return treeSet.toArray(new String[treeSet.size()]);
        }

        Schema getSchema() {
            if (this.schema == null) {
                this.schema = new Schema();
            }
            return this.schema;
        }

        class Schema {
            private Table[] tables = null;

            Schema() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            Table[] getTables() {
                if (this.tables != null) {
                    return this.tables;
                }
                LinkedList<Table> linkedList = new LinkedList<Table>();
                try {
                    ResultSet resultSet = DatabaseConnection.this.meta.getTables(DatabaseConnection.this.connection.getCatalog(), null, "%", new String[]{"TABLE"});
                    try {
                        while (resultSet.next()) {
                            linkedList.add(new Table(resultSet.getString("TABLE_NAME")));
                        }
                    }
                    finally {
                        try {
                            resultSet.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.tables = linkedList.toArray(new Table[0]);
                return this.tables;
            }

            Table getTable(String string) {
                Table[] tableArray = this.getTables();
                for (int i = 0; tableArray != null && i < tableArray.length; ++i) {
                    if (!string.equalsIgnoreCase(tableArray[i].getName())) continue;
                    return tableArray[i];
                }
                return null;
            }

            class Table {
                final String name;
                Column[] columns;

                public Table(String string) {
                    this.name = string;
                }

                public String getName() {
                    return this.name;
                }

                class Column {
                    final String name;
                    boolean isPrimaryKey;

                    public Column(String string) {
                        this.name = string;
                    }
                }
            }
        }
    }

    private static class Connections {
        private final List connections = new ArrayList();
        private int index = -1;

        private Connections() {
        }

        public DatabaseConnection current() {
            if (this.index != -1) {
                return (DatabaseConnection)this.connections.get(this.index);
            }
            return null;
        }

        public int size() {
            return this.connections.size();
        }

        public Iterator iterator() {
            return this.connections.iterator();
        }

        public void remove() {
            if (this.index != -1) {
                this.connections.remove(this.index);
            }
            while (this.index >= this.connections.size()) {
                --this.index;
            }
        }

        public void addConnection(DatabaseConnection databaseConnection) {
            this.connections.add(databaseConnection);
        }

        public void setConnection(DatabaseConnection databaseConnection) {
            if (this.connections.indexOf(databaseConnection) == -1) {
                this.connections.add(databaseConnection);
            }
            this.index = this.connections.indexOf(databaseConnection);
        }

        public int getIndex() {
            return this.index;
        }

        public boolean setIndex(int n) {
            if (n < 0 || n >= this.connections.size()) {
                return false;
            }
            this.index = n;
            return true;
        }
    }

    class SQLLineSQLCompletor
    extends SimpleCompletor {
        public SQLLineSQLCompletor(boolean bl) throws IOException, SQLException {
            super(new String[0]);
            TreeSet<String> treeSet = new TreeSet<String>();
            String string = new BufferedReader(new InputStreamReader((class$sqlline$SqlLine$SQLLineSQLCompletor == null ? (class$sqlline$SqlLine$SQLLineSQLCompletor = SqlLine.class$("sqlline.SqlLine$SQLLineSQLCompletor")) : class$sqlline$SqlLine$SQLLineSQLCompletor).getResourceAsStream("sql-keywords.properties"))).readLine();
            try {
                string = string + "," + SqlLine.this.con().meta.getSQLKeywords();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                string = string + "," + SqlLine.this.con().meta.getStringFunctions();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                string = string + "," + SqlLine.this.con().meta.getNumericFunctions();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                string = string + "," + SqlLine.this.con().meta.getSystemFunctions();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                string = string + "," + SqlLine.this.con().meta.getTimeDateFunctions();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            string = string + "," + string.toLowerCase();
            String[] stringArray = new StringTokenizer(string, ", ");
            while (stringArray.hasMoreTokens()) {
                treeSet.add(stringArray.nextToken());
            }
            if (!bl) {
                stringArray = SqlLine.this.getColumnNames(SqlLine.this.con().meta);
                for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                    treeSet.add(stringArray[i++]);
                }
            }
            this.setCandidateStrings(treeSet.toArray(new String[0]));
        }
    }

    class TableNameCompletor
    implements Completor {
        TableNameCompletor() {
        }

        public int complete(String string, int n, List list) {
            if (SqlLine.this.con() == null) {
                return -1;
            }
            return new SimpleCompletor(SqlLine.this.con().getTableNames(true)).complete(string, n, list);
        }
    }

    class SQLLineCommandCompletor
    extends MultiCompletor {
        public SQLLineCommandCompletor() {
            LinkedList<ArgumentCompletor> linkedList = new LinkedList<ArgumentCompletor>();
            for (int i = 0; i < SqlLine.this.commands.length; ++i) {
                String[] stringArray = SqlLine.this.commands[i].getNames();
                for (int j = 0; stringArray != null && j < stringArray.length; ++j) {
                    Completor[] completorArray = SqlLine.this.commands[i].getParameterCompletors();
                    LinkedList<Object> linkedList2 = new LinkedList<Object>();
                    linkedList2.add(new SimpleCompletor(SqlLine.COMMAND_PREFIX + stringArray[j]));
                    linkedList2.addAll(Arrays.asList(completorArray));
                    linkedList2.add(new NullCompletor());
                    linkedList.add(new ArgumentCompletor(linkedList2.toArray(new Completor[0])));
                }
            }
            this.setCompletors(linkedList.toArray(new Completor[0]));
        }
    }

    class SQLLineCompletor
    implements Completor {
        SQLLineCompletor() {
        }

        public int complete(String string, int n, List list) {
            if (string != null && string.startsWith(SqlLine.COMMAND_PREFIX) && !string.startsWith("!all") && !string.startsWith("!sql")) {
                return SqlLine.this.sqlLineCommandCompletor.complete(string, n, list);
            }
            if (SqlLine.this.con() != null && SqlLine.this.con().sqlLineSQLCompletor != null) {
                return SqlLine.this.con().sqlLineSQLCompletor.complete(string, n, list);
            }
            return -1;
        }
    }

    public class Commands {
        public boolean metadata(String string) {
            SqlLine.this.debug(string);
            String[] stringArray = SqlLine.this.split(string);
            LinkedList<String> linkedList = new LinkedList<String>(Arrays.asList(stringArray));
            if (stringArray == null || stringArray.length == 0) {
                return this.dbinfo("");
            }
            linkedList.remove(0);
            linkedList.remove(0);
            SqlLine.this.debug(((Object)linkedList).toString());
            return this.metadata(stringArray[1], linkedList.toArray(new String[0]));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean metadata(String string, String[] stringArray) {
            block10: {
                try {
                    Method[] methodArray = SqlLine.this.con().meta.getClass().getMethods();
                    TreeSet<String> treeSet = new TreeSet<String>();
                    TreeSet<String> treeSet2 = new TreeSet<String>();
                    for (int i = 0; i < methodArray.length; ++i) {
                        treeSet.add(methodArray[i].getName());
                        treeSet2.add(methodArray[i].getName().toUpperCase());
                    }
                    if (!treeSet2.contains(string.toUpperCase())) {
                        SqlLine.this.error(SqlLine.loc("no-such-method", string));
                        SqlLine.this.error(SqlLine.loc("possible-methods"));
                        Iterator iterator = treeSet.iterator();
                        while (iterator.hasNext()) {
                            SqlLine.this.error("   " + iterator.next());
                        }
                        return false;
                    }
                    Object object = Reflector.invoke(SqlLine.this.con().meta, class$java$sql$DatabaseMetaData == null ? (class$java$sql$DatabaseMetaData = SqlLine.class$("java.sql.DatabaseMetaData")) : class$java$sql$DatabaseMetaData, string, Arrays.asList(stringArray));
                    if (object instanceof ResultSet) {
                        ResultSet resultSet = (ResultSet)object;
                        if (resultSet == null) break block10;
                        try {
                            SqlLine.this.print(resultSet);
                            break block10;
                        }
                        finally {
                            resultSet.close();
                        }
                    }
                    if (object != null) {
                        SqlLine.this.output(object.toString());
                    }
                }
                catch (Exception exception) {
                    return SqlLine.this.error(exception);
                }
            }
            return true;
        }

        public boolean history(String string) {
            List list = SqlLine.this.reader.getHistory().getHistoryList();
            int n = 1;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                SqlLine.this.output(SqlLine.this.color().pad(n + ".", 6).append(iterator.next().toString()));
                ++n;
            }
            return true;
        }

        String arg1(String string, String string2) {
            return this.arg1(string, string2, null);
        }

        String arg1(String string, String string2, String string3) {
            String[] stringArray = SqlLine.this.split(string);
            if (stringArray == null || stringArray.length != 2) {
                if (string3 != null) {
                    return string3;
                }
                throw new IllegalArgumentException(SqlLine.loc("arg-usage", new Object[]{stringArray.length == 0 ? "" : stringArray[0], string2}));
            }
            return stringArray[1];
        }

        public boolean indexes(String string) throws Exception {
            return this.metadata("getIndexInfo", new String[]{SqlLine.this.conn().getCatalog(), null, this.arg1(string, "table name"), "false", "true"});
        }

        public boolean primarykeys(String string) throws Exception {
            return this.metadata("getPrimaryKeys", new String[]{SqlLine.this.conn().getCatalog(), null, this.arg1(string, "table name")});
        }

        public boolean exportedkeys(String string) throws Exception {
            return this.metadata("getExportedKeys", new String[]{SqlLine.this.conn().getCatalog(), null, this.arg1(string, "table name")});
        }

        public boolean importedkeys(String string) throws Exception {
            return this.metadata("getImportedKeys", new String[]{SqlLine.this.conn().getCatalog(), null, this.arg1(string, "table name")});
        }

        public boolean procedures(String string) throws Exception {
            return this.metadata("getProcedures", new String[]{SqlLine.this.conn().getCatalog(), null, this.arg1(string, "procedure name pattern", "%")});
        }

        public boolean tables(String string) throws Exception {
            return this.metadata("getTables", new String[]{SqlLine.this.conn().getCatalog(), null, this.arg1(string, "table name", "%"), null});
        }

        public boolean typeinfo(String string) throws Exception {
            return this.metadata("getTypeInfo", new String[0]);
        }

        public boolean nativesql(String string) throws Exception {
            if (string.startsWith(SqlLine.COMMAND_PREFIX)) {
                string = string.substring(1);
            }
            if (string.startsWith("native")) {
                string = string.substring("native".length() + 1);
            }
            String string2 = SqlLine.this.con().getConnection().nativeSQL(string);
            SqlLine.this.output(string2);
            return true;
        }

        public boolean columns(String string) throws Exception {
            return this.metadata("getColumns", new String[]{SqlLine.this.conn().getCatalog(), null, this.arg1(string, "table name"), "%"});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean dropall(String string) {
            if (SqlLine.this.con() == null || SqlLine.this.con().url == null) {
                return SqlLine.this.error(SqlLine.loc("no-current-connection"));
            }
            try {
                if (!SqlLine.this.reader.readLine(SqlLine.loc("really-drop-all")).equals("y")) {
                    return SqlLine.this.error("abort-drop-all");
                }
                LinkedList<String> linkedList = new LinkedList<String>();
                ResultSet resultSet = SqlLine.this.getTables();
                try {
                    while (resultSet.next()) {
                        linkedList.add("DROP TABLE " + resultSet.getString("TABLE_NAME") + ";");
                    }
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
                return SqlLine.this.runCommands(linkedList) == linkedList.size();
            }
            catch (Exception exception) {
                return SqlLine.this.error(exception);
            }
        }

        public boolean reconnect(String string) {
            if (SqlLine.this.con() == null || SqlLine.this.con().url == null) {
                return SqlLine.this.error(SqlLine.loc("no-current-connection"));
            }
            SqlLine.this.info(SqlLine.loc("reconnecting", SqlLine.this.con().url));
            try {
                SqlLine.this.con().reconnect();
            }
            catch (Exception exception) {
                return SqlLine.this.error(exception);
            }
            return true;
        }

        public boolean scan(String string) throws IOException {
            TreeSet<String> treeSet = new TreeSet<String>();
            if (SqlLine.this.drivers == null) {
                SqlLine.this.drivers = Arrays.asList(SqlLine.this.scanDrivers(string));
            }
            SqlLine.this.info(SqlLine.loc("drivers-found-count", SqlLine.this.drivers.size()));
            Iterator iterator = SqlLine.this.drivers.iterator();
            while (iterator.hasNext()) {
                treeSet.add(((Driver)iterator.next()).getClass().getName());
            }
            SqlLine.this.output(SqlLine.this.color().bold(SqlLine.this.color().pad(SqlLine.loc("compliant"), 10).getMono()).bold(SqlLine.this.color().pad(SqlLine.loc("jdbc-version"), 8).getMono()).bold(SqlLine.this.color(SqlLine.loc("driver-class")).getMono()));
            iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                String string2 = iterator.next().toString();
                try {
                    Driver driver = (Driver)Class.forName(string2).newInstance();
                    ColorBuffer colorBuffer = SqlLine.this.color().pad(driver.jdbcCompliant() ? "yes" : "no", 10).pad(driver.getMajorVersion() + "." + driver.getMinorVersion(), 8).append(string2);
                    if (driver.jdbcCompliant()) {
                        SqlLine.this.output(colorBuffer);
                        continue;
                    }
                    SqlLine.this.output(SqlLine.this.color().red(colorBuffer.getMono()));
                }
                catch (Throwable throwable) {
                    SqlLine.this.output(SqlLine.this.color().red(string2));
                }
            }
            return true;
        }

        public boolean save(String string) throws IOException {
            SqlLine.this.info(SqlLine.loc("saving-options", SqlLine.this.opts.rcFile));
            SqlLine.this.opts.save();
            return true;
        }

        public boolean load(String string) throws IOException {
            SqlLine.this.opts.load();
            SqlLine.this.info(SqlLine.loc("loaded-options", SqlLine.this.opts.rcFile));
            return true;
        }

        public boolean config(String string) {
            try {
                Properties properties = SqlLine.this.opts.toProperties();
                TreeSet<Object> treeSet = new TreeSet<Object>(properties.keySet());
                Iterator iterator = treeSet.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    ColorBuffer colorBuffer = SqlLine.this.color();
                    ColorBuffer colorBuffer2 = SqlLine.this.color();
                    SqlLine.this.opts;
                    SqlLine.this.output(colorBuffer.green(colorBuffer2.pad(string2.substring("sqlline.".length()), 20).getMono()).append(properties.getProperty(string2)));
                }
            }
            catch (Exception exception) {
                return SqlLine.this.error(exception);
            }
            return true;
        }

        public boolean set(String string) {
            if (string == null || string.trim().equals("set") || string.length() == 0) {
                return this.config(null);
            }
            String[] stringArray = SqlLine.this.split(string, 3, "Usage: set <key> <value>");
            if (stringArray == null) {
                return false;
            }
            String string2 = stringArray[1];
            String string3 = stringArray[2];
            boolean bl = SqlLine.this.opts.set(string2, string3, false);
            if (bl && SqlLine.this.opts.getAutosave()) {
                try {
                    SqlLine.this.opts.save();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return bl;
        }

        public boolean commit(String string) throws SQLException {
            if (!SqlLine.this.assertConnection()) {
                return false;
            }
            if (!SqlLine.this.assertAutoCommit()) {
                return false;
            }
            try {
                long l = System.currentTimeMillis();
                SqlLine.this.con().connection.commit();
                long l2 = System.currentTimeMillis();
                SqlLine.this.showWarnings();
                SqlLine.this.info(SqlLine.loc("commit-complete") + " " + SqlLine.loc("time-ms", new Object[]{new Double((double)(l2 - l) / 1000.0)}));
                return true;
            }
            catch (Exception exception) {
                return SqlLine.this.error(exception);
            }
        }

        public boolean rollback(String string) throws SQLException {
            if (!SqlLine.this.assertConnection()) {
                return false;
            }
            if (!SqlLine.this.assertAutoCommit()) {
                return false;
            }
            try {
                long l = System.currentTimeMillis();
                SqlLine.this.con().connection.rollback();
                long l2 = System.currentTimeMillis();
                SqlLine.this.showWarnings();
                SqlLine.this.info(SqlLine.loc("rollback-complete") + " " + SqlLine.loc("time-ms", new Object[]{new Double((double)(l2 - l) / 1000.0)}));
                return true;
            }
            catch (Exception exception) {
                return SqlLine.this.error(exception);
            }
        }

        public boolean autocommit(String string) throws SQLException {
            if (!SqlLine.this.assertConnection()) {
                return false;
            }
            if (string.endsWith("on")) {
                SqlLine.this.con().connection.setAutoCommit(true);
            } else if (string.endsWith("off")) {
                SqlLine.this.con().connection.setAutoCommit(false);
            }
            SqlLine.this.showWarnings();
            SqlLine.this.autocommitStatus(SqlLine.this.con().connection);
            return true;
        }

        public boolean dbinfo(String string) {
            if (!SqlLine.this.assertConnection()) {
                return false;
            }
            SqlLine.this.showWarnings();
            int n = 50;
            String[] stringArray = new String[]{"allProceduresAreCallable", "allTablesAreSelectable", "dataDefinitionCausesTransactionCommit", "dataDefinitionIgnoredInTransactions", "doesMaxRowSizeIncludeBlobs", "getCatalogSeparator", "getCatalogTerm", "getDatabaseProductName", "getDatabaseProductVersion", "getDefaultTransactionIsolation", "getDriverMajorVersion", "getDriverMinorVersion", "getDriverName", "getDriverVersion", "getExtraNameCharacters", "getIdentifierQuoteString", "getMaxBinaryLiteralLength", "getMaxCatalogNameLength", "getMaxCharLiteralLength", "getMaxColumnNameLength", "getMaxColumnsInGroupBy", "getMaxColumnsInIndex", "getMaxColumnsInOrderBy", "getMaxColumnsInSelect", "getMaxColumnsInTable", "getMaxConnections", "getMaxCursorNameLength", "getMaxIndexLength", "getMaxProcedureNameLength", "getMaxRowSize", "getMaxSchemaNameLength", "getMaxStatementLength", "getMaxStatements", "getMaxTableNameLength", "getMaxTablesInSelect", "getMaxUserNameLength", "getNumericFunctions", "getProcedureTerm", "getSchemaTerm", "getSearchStringEscape", "getSQLKeywords", "getStringFunctions", "getSystemFunctions", "getTimeDateFunctions", "getURL", "getUserName", "isCatalogAtStart", "isReadOnly", "nullPlusNonNullIsNull", "nullsAreSortedAtEnd", "nullsAreSortedAtStart", "nullsAreSortedHigh", "nullsAreSortedLow", "storesLowerCaseIdentifiers", "storesLowerCaseQuotedIdentifiers", "storesMixedCaseIdentifiers", "storesMixedCaseQuotedIdentifiers", "storesUpperCaseIdentifiers", "storesUpperCaseQuotedIdentifiers", "supportsAlterTableWithAddColumn", "supportsAlterTableWithDropColumn", "supportsANSI92EntryLevelSQL", "supportsANSI92FullSQL", "supportsANSI92IntermediateSQL", "supportsBatchUpdates", "supportsCatalogsInDataManipulation", "supportsCatalogsInIndexDefinitions", "supportsCatalogsInPrivilegeDefinitions", "supportsCatalogsInProcedureCalls", "supportsCatalogsInTableDefinitions", "supportsColumnAliasing", "supportsConvert", "supportsCoreSQLGrammar", "supportsCorrelatedSubqueries", "supportsDataDefinitionAndDataManipulationTransactions", "supportsDataManipulationTransactionsOnly", "supportsDifferentTableCorrelationNames", "supportsExpressionsInOrderBy", "supportsExtendedSQLGrammar", "supportsFullOuterJoins", "supportsGroupBy", "supportsGroupByBeyondSelect", "supportsGroupByUnrelated", "supportsIntegrityEnhancementFacility", "supportsLikeEscapeClause", "supportsLimitedOuterJoins", "supportsMinimumSQLGrammar", "supportsMixedCaseIdentifiers", "supportsMixedCaseQuotedIdentifiers", "supportsMultipleResultSets", "supportsMultipleTransactions", "supportsNonNullableColumns", "supportsOpenCursorsAcrossCommit", "supportsOpenCursorsAcrossRollback", "supportsOpenStatementsAcrossCommit", "supportsOpenStatementsAcrossRollback", "supportsOrderByUnrelated", "supportsOuterJoins", "supportsPositionedDelete", "supportsPositionedUpdate", "supportsSchemasInDataManipulation", "supportsSchemasInIndexDefinitions", "supportsSchemasInPrivilegeDefinitions", "supportsSchemasInProcedureCalls", "supportsSchemasInTableDefinitions", "supportsSelectForUpdate", "supportsStoredProcedures", "supportsSubqueriesInComparisons", "supportsSubqueriesInExists", "supportsSubqueriesInIns", "supportsSubqueriesInQuantifieds", "supportsTableCorrelationNames", "supportsTransactions", "supportsUnion", "supportsUnionAll", "usesLocalFilePerTable", "usesLocalFiles"};
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    SqlLine.this.output(SqlLine.this.color().pad(stringArray[i], n).append("" + Reflector.invoke((Object)SqlLine.this.con().meta, stringArray[i], new Object[0])));
                    continue;
                }
                catch (Exception exception) {
                    SqlLine.this.handleException(exception);
                }
            }
            return true;
        }

        public boolean verbose(String string) {
            SqlLine.this.info("verbose: on");
            return this.set("set verbose true");
        }

        public boolean outputformat(String string) {
            return this.set("set " + string);
        }

        public boolean brief(String string) {
            SqlLine.this.info("verbose: off");
            return this.set("set verbose false");
        }

        public boolean isolation(String string) throws SQLException {
            String string2;
            int n;
            if (!SqlLine.this.assertConnection()) {
                return false;
            }
            if (string.endsWith("TRANSACTION_NONE")) {
                n = 0;
            } else if (string.endsWith("TRANSACTION_READ_COMMITTED")) {
                n = 2;
            } else if (string.endsWith("TRANSACTION_READ_UNCOMMITTED")) {
                n = 1;
            } else if (string.endsWith("TRANSACTION_REPEATABLE_READ")) {
                n = 4;
            } else if (string.endsWith("TRANSACTION_SERIALIZABLE")) {
                n = 8;
            } else {
                return SqlLine.this.error("Usage: isolation <TRANSACTION_NONE | TRANSACTION_READ_COMMITTED | TRANSACTION_READ_UNCOMMITTED | TRANSACTION_REPEATABLE_READ | TRANSACTION_SERIALIZABLE>");
            }
            SqlLine.this.con().connection.setTransactionIsolation(n);
            int n2 = SqlLine.this.con().connection.getTransactionIsolation();
            switch (n) {
                case 0: {
                    string2 = "TRANSACTION_NONE";
                    break;
                }
                case 2: {
                    string2 = "TRANSACTION_READ_COMMITTED";
                    break;
                }
                case 1: {
                    string2 = "TRANSACTION_READ_UNCOMMITTED";
                    break;
                }
                case 4: {
                    string2 = "TRANSACTION_REPEATABLE_READ";
                    break;
                }
                case 8: {
                    string2 = "TRANSACTION_SERIALIZABLE";
                    break;
                }
                default: {
                    string2 = "UNKNOWN";
                }
            }
            SqlLine.this.info(SqlLine.loc("isolation-status", string2));
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean batch(String string) {
            if (!SqlLine.this.assertConnection()) {
                return false;
            }
            if (SqlLine.this.batch == null) {
                SqlLine.this.batch = new LinkedList();
                SqlLine.this.info(SqlLine.loc("batch-start"));
                return true;
            }
            SqlLine.this.info(SqlLine.loc("running-batch"));
            try {
                SqlLine.this.runBatch(SqlLine.this.batch);
                boolean bl = true;
                return bl;
            }
            catch (Exception exception) {
                boolean bl = SqlLine.this.error(exception);
                return bl;
            }
            finally {
                SqlLine.this.batch = null;
            }
        }

        public boolean sql(String string) {
            return this.execute(string, false);
        }

        public boolean call(String string) {
            return this.execute(string, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean execute(String string, boolean bl) {
            String string2;
            CharSequence charSequence;
            if (string == null || string.length() == 0) {
                return false;
            }
            try {
                while (!string.trim().endsWith(";")) {
                    charSequence = new StringBuffer(SqlLine.this.getPrompt());
                    for (int i = 0; i < ((StringBuffer)charSequence).length() - 1; ++i) {
                        if (((StringBuffer)charSequence).charAt(i) == '>') continue;
                        ((StringBuffer)charSequence).setCharAt(i, i % 2 == 0 ? (char)'.' : ' ');
                    }
                    string2 = SqlLine.this.reader.readLine(((StringBuffer)charSequence).toString());
                    if (SqlLine.this.isComment(string2)) continue;
                    string = string + " " + string2;
                }
            }
            catch (Exception exception) {
                SqlLine.this.handleException(exception);
            }
            if (string.endsWith(";")) {
                string = string.substring(0, string.length() - 1);
            }
            if (!SqlLine.this.assertConnection()) {
                return false;
            }
            charSequence = string;
            if (((String)charSequence).startsWith(SqlLine.COMMAND_PREFIX)) {
                charSequence = ((String)charSequence).substring(1);
            }
            String string3 = string2 = bl ? "call" : "sql";
            if (((String)charSequence).startsWith(string2)) {
                charSequence = ((String)charSequence).substring(string2.length());
            }
            if (SqlLine.this.batch != null) {
                SqlLine.this.batch.add(charSequence);
                return true;
            }
            try {
                Statement statement = null;
                try {
                    boolean bl2;
                    long l = System.currentTimeMillis();
                    if (bl) {
                        statement = SqlLine.this.con().connection.prepareCall((String)charSequence);
                        bl2 = ((CallableStatement)statement).execute();
                    } else {
                        statement = SqlLine.this.createStatement();
                        bl2 = statement.execute((String)charSequence);
                    }
                    SqlLine.this.showWarnings();
                    if (bl2) {
                        do {
                            ResultSet resultSet = statement.getResultSet();
                            try {
                                int n = SqlLine.this.print(resultSet);
                                long l2 = System.currentTimeMillis();
                                SqlLine.this.info(SqlLine.loc("rows-selected", n) + " " + SqlLine.loc("time-ms", new Object[]{new Double((double)(l2 - l) / 1000.0)}));
                            }
                            finally {
                                resultSet.close();
                            }
                        } while (SqlLine.getMoreResults(statement));
                    } else {
                        int n = statement.getUpdateCount();
                        long l3 = System.currentTimeMillis();
                        SqlLine.this.info(SqlLine.loc("rows-affected", n) + " " + SqlLine.loc("time-ms", new Object[]{new Double((double)(l3 - l) / 1000.0)}));
                    }
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            catch (Exception exception) {
                return SqlLine.this.error(exception);
            }
            SqlLine.this.showWarnings();
            return true;
        }

        public boolean quit(String string) {
            SqlLine.this.exit = true;
            this.close(null);
            return true;
        }

        public boolean closeall(String string) {
            if (this.close(null)) {
                while (this.close(null)) {
                }
                return true;
            }
            return false;
        }

        public boolean close(String string) {
            if (SqlLine.this.con() == null) {
                return false;
            }
            try {
                if (SqlLine.this.con().connection != null && !SqlLine.this.con().connection.isClosed()) {
                    SqlLine.this.info(SqlLine.loc("closing", SqlLine.this.con().connection.getClass().getName()));
                    SqlLine.this.con().connection.close();
                } else {
                    SqlLine.this.info(SqlLine.loc("already-closed"));
                }
            }
            catch (Exception exception) {
                return SqlLine.this.error(exception);
            }
            SqlLine.this.connections.remove();
            return true;
        }

        public boolean properties(String string) throws Exception {
            String string2 = "";
            string2 = string2 + "Usage: properties <properties file>" + sep;
            String[] stringArray = SqlLine.this.split(string);
            if (stringArray.length < 2) {
                return SqlLine.this.error(string2);
            }
            int n = 0;
            for (int i = 1; i < stringArray.length; ++i) {
                Properties properties = new Properties();
                properties.load(new FileInputStream(stringArray[i]));
                if (!this.connect(properties)) continue;
                ++n;
            }
            return n == stringArray.length - 1;
        }

        public boolean connect(String string) throws Exception {
            String string2 = "";
            string2 = string2 + "Usage: connect <url> <username> <password> [driver]" + sep;
            String[] stringArray = SqlLine.this.split(string);
            if (stringArray == null) {
                return false;
            }
            if (stringArray.length < 2) {
                return SqlLine.this.error(string2);
            }
            String string3 = stringArray.length < 2 ? null : stringArray[1];
            String string4 = stringArray.length < 3 ? null : stringArray[2];
            String string5 = stringArray.length < 4 ? null : stringArray[3];
            String string6 = stringArray.length < 5 ? null : stringArray[4];
            Properties properties = new Properties();
            if (string3 != null) {
                properties.setProperty("url", string3);
            }
            if (string6 != null) {
                properties.setProperty("driver", string6);
            }
            if (string4 != null) {
                properties.setProperty("user", string4);
            }
            if (string5 != null) {
                properties.setProperty("password", string5);
            }
            return this.connect(properties);
        }

        private String getProperty(Properties properties, String[] stringArray) {
            String string;
            for (int i = 0; i < stringArray.length; ++i) {
                string = properties.getProperty(stringArray[i]);
                if (string == null) continue;
                return string;
            }
            Iterator<Object> iterator = properties.keySet().iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!string.endsWith(stringArray[i])) continue;
                    return properties.getProperty(string);
                }
            }
            return null;
        }

        public boolean connect(Properties properties) throws IOException {
            String string = this.getProperty(properties, new String[]{"url", "javax.jdo.option.ConnectionURL", "ConnectionURL"});
            String string2 = this.getProperty(properties, new String[]{"driver", "javax.jdo.option.ConnectionDriverName", "ConnectionDriverName"});
            String string3 = this.getProperty(properties, new String[]{"user", "javax.jdo.option.ConnectionUserName", "ConnectionUserName"});
            String string4 = this.getProperty(properties, new String[]{"password", "javax.jdo.option.ConnectionPassword", "ConnectionPassword"});
            if (string == null || string.length() == 0) {
                return SqlLine.this.error("Property \"url\" is required");
            }
            if (!(string2 != null && string2.length() != 0 || SqlLine.this.scanForDriver(string))) {
                return SqlLine.this.error(SqlLine.loc("no-driver", string));
            }
            SqlLine.this.info("Connecting to " + string);
            if (string3 == null) {
                string3 = SqlLine.this.reader.readLine("Enter username for " + string + ": ");
            }
            if (string4 == null) {
                string4 = SqlLine.this.reader.readLine("Enter password for " + string + ": ", new Character('*'));
            }
            try {
                SqlLine.this.completions.clear();
                SqlLine.this.connections.setConnection(new DatabaseConnection(string2, string, string3, string4));
                SqlLine.this.con().getConnection();
                SqlLine.this.setCompletions();
                return true;
            }
            catch (SQLException sQLException) {
                return SqlLine.this.error(sQLException);
            }
            catch (IOException iOException) {
                return SqlLine.this.error(iOException);
            }
        }

        public boolean rehash(String string) {
            try {
                if (!SqlLine.this.assertConnection()) {
                    return false;
                }
                SqlLine.this.completions.clear();
                if (SqlLine.this.con() != null) {
                    SqlLine.this.con().setCompletions(false);
                }
                return true;
            }
            catch (Exception exception) {
                return SqlLine.this.error(exception);
            }
        }

        public boolean list(String string) {
            int n = 0;
            SqlLine.this.info(SqlLine.loc("active-connections", SqlLine.this.connections.size()));
            Iterator iterator = SqlLine.this.connections.iterator();
            while (iterator.hasNext()) {
                DatabaseConnection databaseConnection = (DatabaseConnection)iterator.next();
                boolean bl = false;
                try {
                    bl = databaseConnection.connection.isClosed();
                }
                catch (Exception exception) {
                    bl = true;
                }
                SqlLine.this.output(SqlLine.this.color().pad(" #" + n + "", 5).pad(bl ? SqlLine.loc("closed") : SqlLine.loc("open"), 9).append(databaseConnection.url));
                ++n;
            }
            return true;
        }

        public boolean all(String string) {
            int n = SqlLine.this.connections.getIndex();
            boolean bl = true;
            for (int i = 0; i < SqlLine.this.connections.size(); ++i) {
                SqlLine.this.connections.setIndex(i);
                SqlLine.this.output(SqlLine.loc("executing-con", SqlLine.this.con()));
                bl = this.sql(string.substring("all ".length())) && bl;
            }
            SqlLine.this.connections.setIndex(n);
            return bl;
        }

        public boolean go(String string) {
            String[] stringArray = SqlLine.this.split(string, 2, "Usage: go <connection index>");
            if (stringArray == null) {
                return false;
            }
            int n = Integer.parseInt(stringArray[1]);
            if (!SqlLine.this.connections.setIndex(n)) {
                SqlLine.this.error(SqlLine.loc("invalid-connection", "" + n));
                this.list("");
                return false;
            }
            return true;
        }

        public boolean script(String string) {
            if (SqlLine.this.script == null) {
                return this.startScript(string);
            }
            return this.stopScript(string);
        }

        private boolean stopScript(String string) {
            try {
                SqlLine.this.script.close();
            }
            catch (Exception exception) {
                SqlLine.this.handleException(exception);
            }
            SqlLine.this.output(SqlLine.loc("script-closed", SqlLine.this.script));
            SqlLine.this.script = null;
            return true;
        }

        private boolean startScript(String string) {
            if (SqlLine.this.script != null) {
                return SqlLine.this.error(SqlLine.loc("script-already-running", SqlLine.this.script));
            }
            String[] stringArray = SqlLine.this.split(string, 2, "Usage: script <filename>");
            if (stringArray == null) {
                return false;
            }
            try {
                SqlLine.this.script = new OutputFile(stringArray[1]);
                SqlLine.this.output(SqlLine.loc("script-started", SqlLine.this.script));
                return true;
            }
            catch (Exception exception) {
                return SqlLine.this.error(exception);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean run(String string) {
            String[] stringArray = SqlLine.this.split(string, 2, "Usage: run <scriptfile>");
            if (stringArray == null) {
                return false;
            }
            LinkedList<String> linkedList = new LinkedList<String>();
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(stringArray[1]));
                try {
                    String string2;
                    StringBuffer stringBuffer = null;
                    while ((string2 = bufferedReader.readLine()) != null) {
                        if (stringBuffer != null) {
                            string2 = string2.trim();
                            stringBuffer.append(" \n");
                            stringBuffer.append(string2);
                            if (!string2.endsWith(";")) continue;
                            linkedList.add(stringBuffer.toString());
                            stringBuffer = null;
                            continue;
                        }
                        if (SqlLine.this.needsContinuation(string2)) {
                            stringBuffer = new StringBuffer(string2);
                            continue;
                        }
                        linkedList.add(string2);
                    }
                    if (stringBuffer != null) {
                        stringBuffer.append(";");
                        linkedList.add(stringBuffer.toString());
                    }
                }
                finally {
                    bufferedReader.close();
                }
                return SqlLine.this.runCommands(linkedList) == linkedList.size();
            }
            catch (Exception exception) {
                return SqlLine.this.error(exception);
            }
        }

        public boolean record(String string) {
            if (SqlLine.this.record == null) {
                return this.startRecording(string);
            }
            return this.stopRecording(string);
        }

        private boolean stopRecording(String string) {
            try {
                SqlLine.this.record.close();
            }
            catch (Exception exception) {
                SqlLine.this.handleException(exception);
            }
            SqlLine.this.output(SqlLine.loc("record-closed", SqlLine.this.record));
            SqlLine.this.record = null;
            return true;
        }

        private boolean startRecording(String string) {
            if (SqlLine.this.record != null) {
                return SqlLine.this.error(SqlLine.loc("record-already-running", SqlLine.this.record));
            }
            String[] stringArray = SqlLine.this.split(string, 2, "Usage: record <filename>");
            if (stringArray == null) {
                return false;
            }
            try {
                SqlLine.this.record = new OutputFile(stringArray[1]);
                SqlLine.this.output(SqlLine.loc("record-started", SqlLine.this.record));
                return true;
            }
            catch (Exception exception) {
                return SqlLine.this.error(exception);
            }
        }

        public boolean describe(String string) throws SQLException {
            String[] stringArray = SqlLine.this.split(string, 2, "Usage: describe <table name>");
            if (stringArray == null) {
                return false;
            }
            ResultSet resultSet = stringArray[1].equals("tables") ? SqlLine.this.getTables() : SqlLine.this.getColumns(stringArray[1]);
            if (resultSet == null) {
                return false;
            }
            SqlLine.this.print(resultSet);
            resultSet.close();
            return true;
        }

        public boolean help(String string) {
            String[] stringArray = SqlLine.this.split(string);
            String string2 = stringArray.length > 1 ? stringArray[1] : "";
            boolean bl = false;
            TreeSet<ColorBuffer> treeSet = new TreeSet<ColorBuffer>();
            for (int i = 0; i < SqlLine.this.commands.length; ++i) {
                if (string2.length() != 0 && !Arrays.asList(SqlLine.this.commands[i].getNames()).contains(string2)) continue;
                treeSet.add(SqlLine.this.color().pad(SqlLine.COMMAND_PREFIX + SqlLine.this.commands[i].getName(), 20).append(SqlLine.this.wrap(SqlLine.this.commands[i].getHelpText(), 60, 20)));
            }
            Iterator iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                SqlLine.this.output((ColorBuffer)iterator.next());
            }
            if (string2.length() == 0) {
                SqlLine.this.output("");
                SqlLine.this.output(SqlLine.loc("comments", SqlLine.getApplicationContactInformation()));
            }
            return true;
        }

        public boolean manual(String string) throws IOException {
            String string2;
            InputStream inputStream = (class$sqlline$SqlLine == null ? (class$sqlline$SqlLine = SqlLine.class$("sqlline.SqlLine")) : class$sqlline$SqlLine).getResourceAsStream("manual.txt");
            if (inputStream == null) {
                return SqlLine.this.error(SqlLine.loc("no-manual"));
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            int n = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                String string3;
                SqlLine.this.output(string2);
                if (++n % (SqlLine.this.opts.getMaxHeight() - 1) != 0 || (string3 = SqlLine.this.reader.readLine(SqlLine.loc("enter-for-more"))) == null || !string3.startsWith("q")) continue;
            }
            bufferedReader.close();
            return true;
        }
    }

    public class ReflectiveCommandHandler
    extends AbstractCommandHandler {
        public ReflectiveCommandHandler(String[] stringArray, Completor[] completorArray) {
            super(stringArray, SqlLine.loc("help-" + stringArray[0]), completorArray);
        }

        public boolean execute(String string) {
            try {
                Object object = SqlLine.this.command.getClass().getMethod(this.getName(), class$java$lang$String == null ? (class$java$lang$String = SqlLine.class$("java.lang.String")) : class$java$lang$String).invoke((Object)SqlLine.this.command, string);
                return object != null && object instanceof Boolean && (Boolean)object != false;
            }
            catch (Throwable throwable) {
                return SqlLine.this.error(throwable);
            }
        }
    }

    public abstract class AbstractCommandHandler
    implements CommandHandler {
        private final String name;
        private final String[] names;
        private final String helpText;
        private Completor[] parameterCompletors = new Completor[0];

        public AbstractCommandHandler(String[] stringArray, String string, Completor[] completorArray) {
            this.name = stringArray[0];
            this.names = stringArray;
            this.helpText = string;
            if (completorArray == null || completorArray.length == 0) {
                this.parameterCompletors = new Completor[]{new NullCompletor()};
            } else {
                LinkedList<Completor> linkedList = new LinkedList<Completor>(Arrays.asList(completorArray));
                linkedList.add((Completor)new NullCompletor());
                this.parameterCompletors = linkedList.toArray(new Completor[0]);
            }
        }

        public String getHelpText() {
            return this.helpText;
        }

        public String getName() {
            return this.name;
        }

        public String[] getNames() {
            return this.names;
        }

        public String matches(String string) {
            if (string == null || string.length() == 0) {
                return null;
            }
            String[] stringArray = SqlLine.this.split(string);
            if (stringArray == null || stringArray.length == 0) {
                return null;
            }
            for (int i = 0; i < this.names.length; ++i) {
                if (!this.names[i].startsWith(stringArray[0])) continue;
                return this.names[i];
            }
            return null;
        }

        public void setParameterCompletors(Completor[] completorArray) {
            this.parameterCompletors = completorArray;
        }

        public Completor[] getParameterCompletors() {
            return this.parameterCompletors;
        }
    }

    static interface CommandHandler {
        public String getName();

        public String[] getNames();

        public String getHelpText();

        public String matches(String var1);

        public boolean execute(String var1);

        public Completor[] getParameterCompletors();
    }

    static final class ColorBuffer
    implements Comparable {
        private static final ColorAttr BOLD = new ColorAttr("\u001b[1m");
        private static final ColorAttr NORMAL = new ColorAttr("\u001b[m");
        private static final ColorAttr REVERS = new ColorAttr("\u001b[7m");
        private static final ColorAttr LINED = new ColorAttr("\u001b[4m");
        private static final ColorAttr GREY = new ColorAttr("\u001b[1;30m");
        private static final ColorAttr RED = new ColorAttr("\u001b[1;31m");
        private static final ColorAttr GREEN = new ColorAttr("\u001b[1;32m");
        private static final ColorAttr BLUE = new ColorAttr("\u001b[1;34m");
        private static final ColorAttr CYAN = new ColorAttr("\u001b[1;36m");
        private static final ColorAttr YELLOW = new ColorAttr("\u001b[1;33m");
        private static final ColorAttr MAGENTA = new ColorAttr("\u001b[1;35m");
        private static final ColorAttr INVISIBLE = new ColorAttr("\u001b[8m");
        private final List parts = new LinkedList();
        private final boolean useColor;

        public ColorBuffer(boolean bl) {
            this.useColor = bl;
            this.append("");
        }

        public ColorBuffer(String string, boolean bl) {
            this.useColor = bl;
            this.append(string);
        }

        ColorBuffer pad(ColorBuffer colorBuffer, int n) {
            while (colorBuffer.getVisibleLength() < n) {
                colorBuffer.append(" ");
            }
            return this.append(colorBuffer);
        }

        ColorBuffer center(String string, int n) {
            StringBuffer stringBuffer = new StringBuffer(string);
            while (stringBuffer.length() < n) {
                stringBuffer.append(" ");
                if (stringBuffer.length() >= n) continue;
                stringBuffer.insert(0, " ");
            }
            return this.append(stringBuffer.toString());
        }

        ColorBuffer pad(String string, int n) {
            if (string == null) {
                string = "";
            }
            return this.pad(new ColorBuffer(string, false), n);
        }

        public String getColor() {
            return this.getBuffer(this.useColor);
        }

        public String getMono() {
            return this.getBuffer(false);
        }

        String getBuffer(boolean bl) {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.parts.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!bl && e instanceof ColorAttr) continue;
                stringBuffer.append(e.toString());
            }
            return stringBuffer.toString();
        }

        public ColorBuffer truncate(int n) {
            ColorBuffer colorBuffer = new ColorBuffer(this.useColor);
            ColorAttr colorAttr = null;
            Iterator iterator = this.parts.iterator();
            while (colorBuffer.getVisibleLength() < n && iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof ColorAttr) {
                    colorAttr = (ColorAttr)e;
                    colorBuffer.append((ColorAttr)e);
                    continue;
                }
                String string = e.toString();
                if (colorBuffer.getVisibleLength() + string.length() > n) {
                    int n2 = n - colorBuffer.getVisibleLength();
                    string = string.substring(0, n2);
                }
                colorBuffer.append(string);
            }
            if (colorAttr != null && colorAttr != NORMAL) {
                colorBuffer.append(NORMAL);
            }
            return colorBuffer;
        }

        public String toString() {
            return this.getColor();
        }

        public ColorBuffer append(String string) {
            this.parts.add(string);
            return this;
        }

        public ColorBuffer append(ColorBuffer colorBuffer) {
            this.parts.addAll(colorBuffer.parts);
            return this;
        }

        public ColorBuffer append(ColorAttr colorAttr) {
            this.parts.add(colorAttr);
            return this;
        }

        public int getVisibleLength() {
            return this.getMono().length();
        }

        public ColorBuffer append(ColorAttr colorAttr, String string) {
            this.parts.add(colorAttr);
            this.parts.add(string);
            this.parts.add(NORMAL);
            return this;
        }

        public ColorBuffer bold(String string) {
            return this.append(BOLD, string);
        }

        public ColorBuffer lined(String string) {
            return this.append(LINED, string);
        }

        public ColorBuffer grey(String string) {
            return this.append(GREY, string);
        }

        public ColorBuffer red(String string) {
            return this.append(RED, string);
        }

        public ColorBuffer blue(String string) {
            return this.append(BLUE, string);
        }

        public ColorBuffer green(String string) {
            return this.append(GREEN, string);
        }

        public ColorBuffer cyan(String string) {
            return this.append(CYAN, string);
        }

        public ColorBuffer yellow(String string) {
            return this.append(YELLOW, string);
        }

        public ColorBuffer magenta(String string) {
            return this.append(MAGENTA, string);
        }

        public int compareTo(Object object) {
            return this.getMono().compareTo(((ColorBuffer)object).getMono());
        }

        private static class ColorAttr {
            private final String attr;

            public ColorAttr(String string) {
                this.attr = string;
            }

            public String toString() {
                return this.attr;
            }
        }
    }

    class IncrementalRows
    extends Rows {
        private final ResultSet rs;
        private Rows.Row labelRow;
        private Rows.Row maxRow;
        private Rows.Row nextRow;
        private boolean endOfResult;
        private boolean normalizingWidths;

        IncrementalRows(ResultSet resultSet) throws SQLException {
            super(resultSet);
            this.rs = resultSet;
            this.labelRow = new Rows.Row(this.rsMeta.getColumnCount());
            this.maxRow = new Rows.Row(this.rsMeta.getColumnCount());
            for (int i = 0; i < this.maxRow.sizes.length; ++i) {
                ((Rows.Row)this.maxRow).sizes[i] = Math.max(this.maxRow.sizes[i], this.rsMeta.getColumnDisplaySize(i + 1));
            }
            this.nextRow = this.labelRow;
            this.endOfResult = false;
        }

        public boolean hasNext() {
            if (this.endOfResult) {
                return false;
            }
            if (this.nextRow == null) {
                try {
                    if (this.rs.next()) {
                        this.nextRow = new Rows.Row(this.labelRow.sizes.length, this.rs);
                        if (this.normalizingWidths) {
                            Rows.Row.access$302(this.nextRow, this.labelRow.sizes);
                        }
                    } else {
                        this.endOfResult = true;
                    }
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException(sQLException.toString());
                }
            }
            return this.nextRow != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Rows.Row row = this.nextRow;
            try {
                if (this.rs.next()) {
                    this.nextRow = new Rows.Row(this.labelRow.sizes.length, this.rs);
                    if (this.normalizingWidths) {
                        Rows.Row.access$302(this.nextRow, this.labelRow.sizes);
                    }
                } else {
                    this.nextRow = null;
                }
                return row;
            }
            catch (SQLException sQLException) {
                throw new NoSuchElementException(sQLException.toString());
            }
        }

        void normalizeWidths() {
            Rows.Row.access$302(this.labelRow, this.maxRow.sizes);
            this.normalizingWidths = true;
        }
    }

    class BufferedRows
    extends Rows {
        private final LinkedList list = new LinkedList();
        private final Iterator iterator;

        BufferedRows(ResultSet resultSet) throws SQLException {
            super(resultSet);
            int n = this.rsMeta.getColumnCount();
            this.list.add(new Rows.Row(n));
            while (resultSet.next()) {
                this.list.add(new Rows.Row(n, resultSet));
            }
            this.iterator = this.list.iterator();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            return this.iterator.next();
        }

        void normalizeWidths() {
            Rows.Row row;
            int n;
            int[] nArray = null;
            for (n = 0; n < this.list.size(); ++n) {
                row = (Rows.Row)this.list.get(n);
                if (nArray == null) {
                    nArray = new int[row.values.length];
                }
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = Math.max(nArray[i], row.sizes[i] + 1);
                }
            }
            for (n = 0; n < this.list.size(); ++n) {
                row = (Rows.Row)this.list.get(n);
                Rows.Row.access$302(row, nArray);
            }
        }
    }

    abstract class Rows
    implements Iterator {
        final ResultSetMetaData rsMeta;
        final Boolean[] primaryKeys;

        Rows(ResultSet resultSet) throws SQLException {
            this.rsMeta = resultSet.getMetaData();
            int n = this.rsMeta.getColumnCount();
            this.primaryKeys = new Boolean[n];
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        abstract void normalizeWidths();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        boolean isPrimaryKey(int n) {
            if (this.primaryKeys[n] != null) {
                return this.primaryKeys[n];
            }
            try {
                String string = this.rsMeta.getTableName(n + 1);
                String string2 = this.rsMeta.getColumnName(n + 1);
                if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
                    this.primaryKeys[n] = new Boolean(false);
                    return this.primaryKeys[n];
                }
                ResultSet resultSet = SqlLine.this.con().meta.getPrimaryKeys(SqlLine.this.con().meta.getConnection().getCatalog(), null, string);
                try {
                    while (resultSet.next()) {
                        if (!string2.equalsIgnoreCase(resultSet.getString("COLUMN_NAME"))) continue;
                        this.primaryKeys[n] = new Boolean(true);
                        boolean bl = this.primaryKeys[n];
                        return bl;
                    }
                }
                finally {
                    resultSet.close();
                }
                this.primaryKeys[n] = new Boolean(false);
                return this.primaryKeys[n];
            }
            catch (SQLException sQLException) {
                this.primaryKeys[n] = new Boolean(false);
                return this.primaryKeys[n];
            }
        }

        class Row {
            final String[] values;
            final boolean isMeta;
            private boolean deleted;
            private boolean inserted;
            private boolean updated;
            private int[] sizes;

            Row(int n) throws SQLException {
                this.isMeta = true;
                this.values = new String[n];
                this.sizes = new int[n];
                for (int i = 0; i < n; ++i) {
                    this.values[i] = Rows.this.rsMeta.getColumnLabel(i + 1);
                    this.sizes[i] = this.values[i] == null ? 1 : this.values[i].length();
                }
                this.deleted = false;
                this.updated = false;
                this.inserted = false;
            }

            Row(int n, ResultSet resultSet) throws SQLException {
                this.isMeta = false;
                this.values = new String[n];
                this.sizes = new int[n];
                try {
                    this.deleted = resultSet.rowDeleted();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    this.updated = resultSet.rowUpdated();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    this.inserted = resultSet.rowInserted();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                for (int i = 0; i < n; ++i) {
                    this.values[i] = resultSet.getString(i + 1);
                    this.sizes[i] = this.values[i] == null ? 1 : this.values[i].length();
                }
            }

            static /* synthetic */ int[] access$302(Row row, int[] nArray) {
                row.sizes = nArray;
                return nArray;
            }
        }
    }

    class TableOutputFormat
    implements OutputFormat {
        TableOutputFormat() {
        }

        public int print(Rows rows) {
            int n = 0;
            ColorBuffer colorBuffer = null;
            ColorBuffer colorBuffer2 = null;
            int n2 = SqlLine.this.opts.getMaxWidth() - 4;
            rows.normalizeWidths();
            while (rows.hasNext()) {
                Rows.Row row = (Rows.Row)rows.next();
                ColorBuffer colorBuffer3 = this.getOutputString(rows, row);
                colorBuffer3 = colorBuffer3.truncate(n2);
                if (n == 0) {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < row.sizes.length; ++i) {
                        for (int j = 0; j < row.sizes[i]; ++j) {
                            stringBuffer.append('-');
                        }
                        stringBuffer.append("-+-");
                    }
                    colorBuffer2 = colorBuffer3;
                    colorBuffer = SqlLine.this.color().green(stringBuffer.toString()).truncate(colorBuffer2.getVisibleLength());
                }
                if (n == 0 || SqlLine.this.opts.getHeaderInterval() > 0 && n % SqlLine.this.opts.getHeaderInterval() == 0 && SqlLine.this.opts.getShowHeader()) {
                    this.printRow(colorBuffer, true);
                    this.printRow(colorBuffer2, false);
                    this.printRow(colorBuffer, true);
                }
                if (n != 0) {
                    this.printRow(colorBuffer3, false);
                }
                ++n;
            }
            if (colorBuffer != null && SqlLine.this.opts.getShowHeader()) {
                this.printRow(colorBuffer, true);
            }
            return n - 1;
        }

        void printRow(ColorBuffer colorBuffer, boolean bl) {
            if (bl) {
                SqlLine.this.output(SqlLine.this.color().green("+-").append(colorBuffer).green("-+"));
            } else {
                SqlLine.this.output(SqlLine.this.color().green("| ").append(colorBuffer).green(" |"));
            }
        }

        public ColorBuffer getOutputString(Rows rows, Rows.Row row) {
            return this.getOutputString(rows, row, " | ");
        }

        ColorBuffer getOutputString(Rows rows, Rows.Row row, String string) {
            ColorBuffer colorBuffer = SqlLine.this.color();
            for (int i = 0; i < row.values.length; ++i) {
                ColorBuffer colorBuffer2;
                if (colorBuffer.getVisibleLength() > 0) {
                    colorBuffer.green(string);
                }
                if (row.isMeta) {
                    colorBuffer2 = SqlLine.this.color().center(row.values[i], row.sizes[i]);
                    if (rows.isPrimaryKey(i)) {
                        colorBuffer.cyan(colorBuffer2.getMono());
                        continue;
                    }
                    colorBuffer.bold(colorBuffer2.getMono());
                    continue;
                }
                colorBuffer2 = SqlLine.this.color().pad(row.values[i], row.sizes[i]);
                if (rows.isPrimaryKey(i)) {
                    colorBuffer.cyan(colorBuffer2.getMono());
                    continue;
                }
                colorBuffer.append(colorBuffer2.getMono());
            }
            if (row.deleted) {
                colorBuffer = SqlLine.this.color().red(colorBuffer.getMono());
            } else if (row.updated) {
                colorBuffer = SqlLine.this.color().blue(colorBuffer.getMono());
            } else if (row.inserted) {
                colorBuffer = SqlLine.this.color().green(colorBuffer.getMono());
            }
            return colorBuffer;
        }
    }

    class SeparatedValuesOutputFormat
    implements OutputFormat {
        private char separator;

        public SeparatedValuesOutputFormat(char c) {
            this.setSeparator(c);
        }

        public int print(Rows rows) {
            int n = 0;
            while (rows.hasNext()) {
                this.printRow(rows, (Rows.Row)rows.next());
                ++n;
            }
            return n - 1;
        }

        public void printRow(Rows rows, Rows.Row row) {
            String[] stringArray = row.values;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(stringBuffer.length() == 0 ? "" : "" + this.getSeparator()).append('\'').append(stringArray[i] == null ? "" : stringArray[i]).append('\'');
            }
            SqlLine.this.output(stringBuffer.toString());
        }

        public void setSeparator(char c) {
            this.separator = c;
        }

        public char getSeparator() {
            return this.separator;
        }
    }

    class VerticalOutputFormat
    implements OutputFormat {
        VerticalOutputFormat() {
        }

        public int print(Rows rows) {
            int n = 0;
            Rows.Row row = (Rows.Row)rows.next();
            while (rows.hasNext()) {
                this.printRow(rows, row, (Rows.Row)rows.next());
                ++n;
            }
            return n;
        }

        public void printRow(Rows rows, Rows.Row row, Rows.Row row2) {
            int n;
            String[] stringArray = row.values;
            String[] stringArray2 = row2.values;
            int n2 = 0;
            for (n = 0; n < stringArray.length && n < stringArray2.length; ++n) {
                n2 = Math.max(n2, stringArray[n].length());
            }
            n2 += 2;
            for (n = 0; n < stringArray.length && n < stringArray2.length; ++n) {
                SqlLine.this.output(SqlLine.this.color().bold(SqlLine.this.color().pad(stringArray[n], n2).getMono()).append(stringArray2[n] == null ? "" : stringArray2[n]));
            }
            SqlLine.this.output("");
        }
    }

    class XMLElementOutputFormat
    extends AbstractOutputFormat {
        XMLElementOutputFormat() {
        }

        public void printHeader(Rows.Row row) {
            SqlLine.this.output("<resultset>");
        }

        public void printFooter(Rows.Row row) {
            SqlLine.this.output("</resultset>");
        }

        public void printRow(Rows rows, Rows.Row row, Rows.Row row2) {
            String[] stringArray = row.values;
            String[] stringArray2 = row2.values;
            SqlLine.this.output("  <result>");
            for (int i = 0; i < stringArray.length && i < stringArray2.length; ++i) {
                SqlLine.this.output("    <" + stringArray[i] + ">" + SqlLine.xmlattrencode(stringArray2[i]) + "</" + stringArray[i] + ">");
            }
            SqlLine.this.output("  </result>");
        }
    }

    class XMLAttributeOutputFormat
    extends AbstractOutputFormat {
        XMLAttributeOutputFormat() {
        }

        public void printHeader(Rows.Row row) {
            SqlLine.this.output("<resultset>");
        }

        public void printFooter(Rows.Row row) {
            SqlLine.this.output("</resultset>");
        }

        public void printRow(Rows rows, Rows.Row row, Rows.Row row2) {
            String[] stringArray = row.values;
            String[] stringArray2 = row2.values;
            StringBuffer stringBuffer = new StringBuffer("  <result");
            for (int i = 0; i < stringArray.length && i < stringArray2.length; ++i) {
                stringBuffer.append(' ').append(stringArray[i]).append("=\"").append(SqlLine.xmlattrencode(stringArray2[i])).append('\"');
            }
            stringBuffer.append("/>");
            SqlLine.this.output(stringBuffer.toString());
        }
    }

    abstract class AbstractOutputFormat
    implements OutputFormat {
        AbstractOutputFormat() {
        }

        public int print(Rows rows) {
            int n = 0;
            Rows.Row row = (Rows.Row)rows.next();
            this.printHeader(row);
            while (rows.hasNext()) {
                this.printRow(rows, row, (Rows.Row)rows.next());
                ++n;
            }
            this.printFooter(row);
            return n;
        }

        abstract void printHeader(Rows.Row var1);

        abstract void printFooter(Rows.Row var1);

        abstract void printRow(Rows var1, Rows.Row var2, Rows.Row var3);
    }

    static interface OutputFormat {
        public int print(Rows var1);
    }
}

